/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.azuremonitor;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.telemetry.MetricTelemetry;
import com.microsoft.applicationinsights.telemetry.SeverityLevel;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import com.microsoft.applicationinsights.telemetry.TraceTelemetry;
import io.micrometer.azuremonitor.AzureMonitorConfig;
import io.micrometer.azuremonitor.AzureMonitorNamingConvention;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MissingRequiredConfigurationException;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.StringUtils;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.lang.Nullable;
import java.time.Duration;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureMonitorMeterRegistry
extends StepMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("azure-metrics-publisher");
    private static final String SDK_TELEMETRY_SYNTHETIC_SOURCE_NAME = "SDKTelemetry";
    private static final String SDK_VERSION = "java:micrometer";
    private final Logger logger = LoggerFactory.getLogger(AzureMonitorMeterRegistry.class);
    private final TelemetryClient client;
    private final AzureMonitorConfig config;

    public AzureMonitorMeterRegistry(AzureMonitorConfig config, Clock clock) {
        this(config, clock, TelemetryConfiguration.getActive(), DEFAULT_THREAD_FACTORY);
    }

    private AzureMonitorMeterRegistry(AzureMonitorConfig config, Clock clock, TelemetryConfiguration telemetryConfiguration, ThreadFactory threadFactory) {
        super((StepRegistryConfig)config, clock);
        this.config = config;
        this.config().namingConvention((NamingConvention)new AzureMonitorNamingConvention());
        if (StringUtils.isEmpty((String)telemetryConfiguration.getInstrumentationKey())) {
            if (config.instrumentationKey() == null) {
                throw new MissingRequiredConfigurationException("instrumentationKey must be set to report metrics to Azure Monitor");
            }
            telemetryConfiguration.setInstrumentationKey(config.instrumentationKey());
        }
        this.client = new TelemetryClient(telemetryConfiguration);
        this.client.getContext().getInternal().setSdkVersion(SDK_VERSION);
        this.start(threadFactory);
    }

    public static Builder builder(AzureMonitorConfig config) {
        return new Builder(config);
    }

    public void start(ThreadFactory threadFactory) {
        if (this.config.enabled()) {
            this.logger.info("publishing metrics to azure monitor every " + TimeUtils.format((Duration)this.config.step()));
        }
        super.start(threadFactory);
    }

    protected void publish() {
        for (Meter meter : this.getMeters()) {
            ((Stream)meter.match(this::trackGauge, this::trackCounter, this::trackTimer, this::trackDistributionSummary, this::trackLongTaskTimer, this::trackTimeGauge, this::trackFunctionCounter, this::trackFunctionTimer, this::trackMeter)).forEach(telemetry -> {
                try {
                    this.client.track((Telemetry)telemetry);
                }
                catch (Throwable e) {
                    this.logger.warn("failed to track metric {} in azure monitor", (Object)meter.getId());
                    TraceTelemetry traceTelemetry = new TraceTelemetry("failed to track metric " + meter.getId());
                    traceTelemetry.getContext().getOperation().setSyntheticSource(SDK_TELEMETRY_SYNTHETIC_SOURCE_NAME);
                    traceTelemetry.setSeverityLevel(SeverityLevel.Warning);
                    this.client.trackTrace(traceTelemetry);
                    this.client.flush();
                }
            });
        }
    }

    private Stream<MetricTelemetry> trackMeter(Meter meter) {
        return StreamSupport.stream(meter.measure().spliterator(), false).map(ms -> {
            MetricTelemetry mt = this.createMetricTelemetry(meter, ms.getStatistic().toString().toLowerCase());
            mt.setValue(ms.getValue());
            return mt;
        });
    }

    private Stream<MetricTelemetry> trackLongTaskTimer(LongTaskTimer timer) {
        MetricTelemetry active = this.createMetricTelemetry((Meter)timer, "active");
        active.setValue((double)timer.activeTasks());
        MetricTelemetry duration = this.createMetricTelemetry((Meter)timer, "duration");
        duration.setValue(timer.duration(this.getBaseTimeUnit()));
        return Stream.of(active, duration);
    }

    Stream<MetricTelemetry> trackDistributionSummary(DistributionSummary summary) {
        long count = summary.count();
        if (count == 0L) {
            return Stream.empty();
        }
        MetricTelemetry mt = this.createMetricTelemetry((Meter)summary, null);
        mt.setValue(summary.totalAmount());
        mt.setCount(Integer.valueOf(AzureMonitorMeterRegistry.castCountToInt(count)));
        mt.setMax(Double.valueOf(summary.max()));
        mt.setMin(Double.valueOf(0.0));
        return Stream.of(mt);
    }

    Stream<MetricTelemetry> trackTimer(Timer timer) {
        long count = timer.count();
        if (count == 0L) {
            return Stream.empty();
        }
        MetricTelemetry mt = this.createMetricTelemetry((Meter)timer, null);
        mt.setValue(timer.totalTime(this.getBaseTimeUnit()));
        mt.setCount(Integer.valueOf(AzureMonitorMeterRegistry.castCountToInt(count)));
        mt.setMin(Double.valueOf(0.0));
        mt.setMax(Double.valueOf(timer.max(this.getBaseTimeUnit())));
        return Stream.of(mt);
    }

    Stream<MetricTelemetry> trackFunctionTimer(FunctionTimer timer) {
        double count = timer.count();
        if (count == 0.0) {
            return Stream.empty();
        }
        MetricTelemetry mt = this.createMetricTelemetry((Meter)timer, null);
        mt.setValue(timer.totalTime(this.getBaseTimeUnit()));
        mt.setCount(Integer.valueOf(AzureMonitorMeterRegistry.castCountToInt(count)));
        return Stream.of(mt);
    }

    private Stream<MetricTelemetry> trackCounter(Counter counter) {
        MetricTelemetry mt = this.createMetricTelemetry((Meter)counter, null);
        mt.setValue(counter.count());
        return Stream.of(mt);
    }

    private Stream<MetricTelemetry> trackFunctionCounter(FunctionCounter counter) {
        MetricTelemetry mt = this.createMetricTelemetry((Meter)counter, null);
        mt.setValue(counter.count());
        return Stream.of(mt);
    }

    private Stream<MetricTelemetry> trackGauge(Gauge gauge) {
        MetricTelemetry mt = this.createMetricTelemetry((Meter)gauge, null);
        mt.setValue(gauge.value());
        return Stream.of(mt);
    }

    private Stream<MetricTelemetry> trackTimeGauge(TimeGauge meter) {
        MetricTelemetry mt = this.createMetricTelemetry((Meter)meter, null);
        mt.setValue(meter.value(this.getBaseTimeUnit()));
        return Stream.of(mt);
    }

    private MetricTelemetry createMetricTelemetry(Meter meter, @Nullable String suffix) {
        MetricTelemetry mt = new MetricTelemetry();
        Meter.Id id = meter.getId();
        mt.setName(this.config().namingConvention().name(id.getName() + (suffix == null ? "" : "." + suffix), id.getType(), id.getBaseUnit()));
        for (Tag tag : this.getConventionTags(meter.getId())) {
            mt.getContext().getProperties().putIfAbsent(tag.getKey(), tag.getValue());
        }
        return mt;
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    public void close() {
        this.client.flush();
        super.close();
    }

    private static int castCountToInt(long count) {
        return count < Integer.MAX_VALUE ? (int)count : Integer.MAX_VALUE;
    }

    private static int castCountToInt(double count) {
        return count < 2.147483647E9 ? (int)count : Integer.MAX_VALUE;
    }

    static /* synthetic */ ThreadFactory access$000() {
        return DEFAULT_THREAD_FACTORY;
    }

    public static class Builder {
        private final AzureMonitorConfig config;
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = AzureMonitorMeterRegistry.access$000();
        @Nullable
        private TelemetryConfiguration telemetryConfiguration;

        Builder(AzureMonitorConfig config) {
            this.config = config;
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder telemetryConfiguration(TelemetryConfiguration telemetryConfiguration) {
            this.telemetryConfiguration = telemetryConfiguration;
            return this;
        }

        public AzureMonitorMeterRegistry build() {
            return new AzureMonitorMeterRegistry(this.config, this.clock, this.telemetryConfiguration == null ? TelemetryConfiguration.getActive() : this.telemetryConfiguration, this.threadFactory);
        }
    }
}

