/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.appoptics;

import io.micrometer.appoptics.AppOpticsConfig;
import io.micrometer.appoptics.AppOpticsNamingConvention;
import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppOpticsMeterRegistry
extends StepMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("appoptics-metrics-publisher");
    protected static final String BODY_MEASUREMENTS_PREFIX = "{\"time\": %d, \"measurements\":[";
    private static final String BODY_MEASUREMENTS_SUFFIX = "]}";
    private final Logger logger = LoggerFactory.getLogger(AppOpticsMeterRegistry.class);
    private final AppOpticsConfig config;
    private final HttpSender httpClient;

    public AppOpticsMeterRegistry(AppOpticsConfig config, Clock clock) {
        this(config, clock, DEFAULT_THREAD_FACTORY, (HttpSender)new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout()));
    }

    protected AppOpticsMeterRegistry(AppOpticsConfig config, Clock clock, ThreadFactory threadFactory, HttpSender httpClient) {
        super((StepRegistryConfig)config, clock);
        this.config().namingConvention((NamingConvention)new AppOpticsNamingConvention());
        this.config = config;
        this.httpClient = httpClient;
        this.config().meterFilter(new MeterFilter(){

            public Meter.Id map(Meter.Id id) {
                if (id.getName().startsWith("system.")) {
                    return id.withName("micrometer." + id.getName());
                }
                return id;
            }
        });
        this.start(threadFactory);
    }

    public static Builder builder(AppOpticsConfig config) {
        return new Builder(config);
    }

    protected void publish() {
        try {
            String bodyMeasurementsPrefix = this.getBodyMeasurementsPrefix();
            for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
                List meters = batch.stream().map(meter -> (Optional)meter.match(this::writeGauge, this::writeCounter, this::writeTimer, this::writeSummary, this::writeLongTaskTimer, this::writeTimeGauge, this::writeFunctionCounter, this::writeFunctionTimer, this::writeMeter)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                if (meters.isEmpty()) continue;
                this.httpClient.post(this.config.uri()).withBasicAuthentication(this.config.apiToken(), "").withJsonContent(meters.stream().collect(Collectors.joining(",", bodyMeasurementsPrefix, BODY_MEASUREMENTS_SUFFIX))).send().onSuccess(response -> {
                    if (!response.body().contains("\"failed\":0")) {
                        this.logger.error("failed to send at least some metrics to appoptics: {}", (Object)response.body());
                    } else {
                        this.logger.debug("successfully sent {} metrics to appoptics", (Object)batch.size());
                    }
                }).onError(response -> this.logger.error("failed to send metrics to appoptics: {}", (Object)response.body()));
            }
        }
        catch (Throwable t) {
            this.logger.warn("failed to send metrics to appoptics", t);
        }
    }

    String getBodyMeasurementsPrefix() {
        long stepSeconds = this.config.step().getSeconds();
        long wallTimeInSeconds = TimeUnit.MILLISECONDS.toSeconds(this.clock.wallTime());
        if (this.config.floorTimes()) {
            wallTimeInSeconds -= wallTimeInSeconds % stepSeconds;
        }
        return String.format(BODY_MEASUREMENTS_PREFIX, wallTimeInSeconds);
    }

    Optional<String> writeMeter(Meter meter) {
        Iterable measurements = meter.measure();
        ArrayList<Statistic> statistics = new ArrayList<Statistic>();
        ArrayList<Double> values = new ArrayList<Double>();
        for (Measurement measurement : measurements) {
            double value = measurement.getValue();
            if (!Double.isFinite(value)) continue;
            statistics.add(measurement.getStatistic());
            values.add(value);
        }
        if (statistics.isEmpty()) {
            return Optional.empty();
        }
        StringJoiner joiner = new StringJoiner(",");
        for (int i = 0; i < statistics.size(); ++i) {
            joiner.add(this.write(meter.getId().withTag((Statistic)statistics.get(i)), null, Fields.Value.tag(), DoubleFormat.decimal((double)((Double)values.get(i)))));
        }
        return Optional.of(joiner.toString());
    }

    Optional<String> writeGauge(Gauge gauge) {
        double value = gauge.value();
        if (!Double.isFinite(value)) {
            return Optional.empty();
        }
        return Optional.of(this.write(gauge.getId(), "gauge", Fields.Value.tag(), DoubleFormat.decimal((double)value)));
    }

    Optional<String> writeTimeGauge(TimeGauge timeGauge) {
        double value = timeGauge.value(this.getBaseTimeUnit());
        if (!Double.isFinite(value)) {
            return Optional.empty();
        }
        return Optional.of(this.write(timeGauge.getId(), "timeGauge", Fields.Value.tag(), DoubleFormat.decimal((double)value)));
    }

    private Optional<String> writeCounter(Counter counter) {
        double count = counter.count();
        if (count > 0.0) {
            return Optional.of(this.write(counter.getId(), "counter", Fields.Value.tag(), DoubleFormat.decimal((double)count)));
        }
        return Optional.empty();
    }

    Optional<String> writeFunctionCounter(FunctionCounter counter) {
        double count = counter.count();
        if (Double.isFinite(count) && count > 0.0) {
            return Optional.of(this.write(counter.getId(), "functionCounter", Fields.Value.tag(), DoubleFormat.decimal((double)count)));
        }
        return Optional.empty();
    }

    private Optional<String> writeFunctionTimer(FunctionTimer timer) {
        double count = timer.count();
        if (count > 0.0) {
            return Optional.of(this.write(timer.getId(), "functionTimer", Fields.Count.tag(), DoubleFormat.decimal((double)count), Fields.Sum.tag(), DoubleFormat.decimal((double)timer.totalTime(this.getBaseTimeUnit()))));
        }
        return Optional.empty();
    }

    private Optional<String> writeTimer(Timer timer) {
        HistogramSnapshot snapshot = timer.takeSnapshot();
        long count = snapshot.count();
        if (count > 0L) {
            return Optional.of(this.write(timer.getId(), "timer", Fields.Count.tag(), DoubleFormat.decimal((double)count), Fields.Sum.tag(), DoubleFormat.decimal((double)snapshot.total(this.getBaseTimeUnit())), Fields.Max.tag(), DoubleFormat.decimal((double)snapshot.max(this.getBaseTimeUnit()))));
        }
        return Optional.empty();
    }

    private Optional<String> writeSummary(DistributionSummary summary) {
        HistogramSnapshot snapshot = summary.takeSnapshot();
        if (snapshot.count() > 0L) {
            return Optional.of(this.write(summary.getId(), "distributionSummary", Fields.Count.tag(), DoubleFormat.decimal((double)summary.count()), Fields.Sum.tag(), DoubleFormat.decimal((double)summary.totalAmount()), Fields.Max.tag(), DoubleFormat.decimal((double)summary.max())));
        }
        return Optional.empty();
    }

    private Optional<String> writeLongTaskTimer(LongTaskTimer timer) {
        int activeTasks = timer.activeTasks();
        if (activeTasks > 0) {
            return Optional.of(this.write(timer.getId(), "longTaskTimer", Fields.Count.tag(), DoubleFormat.decimal((double)activeTasks), Fields.Sum.tag(), DoubleFormat.decimal((double)timer.duration(this.getBaseTimeUnit()))));
        }
        return Optional.empty();
    }

    private String write(Meter.Id id, @Nullable String type, String ... statistics) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"name\":\"").append(StringEscapeUtils.escapeJson((String)this.getConventionName(id))).append("\",\"period\":").append(this.config.step().getSeconds());
        if (!Fields.Value.tag().equals(statistics[0])) {
            sb.append(",\"attributes\":{\"aggregate\":false}");
        }
        for (int i = 0; i < statistics.length; i += 2) {
            sb.append(",\"").append(statistics[i]).append("\":").append(statistics[i + 1]);
        }
        List tags = id.getTags();
        sb.append(",\"tags\":{");
        if (type != null) {
            sb.append("\"_type\":\"").append(type).append('\"');
            if (!tags.isEmpty()) {
                sb.append(',');
            }
        }
        if (!tags.isEmpty()) {
            sb.append(tags.stream().map(tag -> {
                String key = tag.getKey();
                if (key.equals(this.config.hostTag())) {
                    key = "host_hostname_alias";
                }
                return "\"" + this.config().namingConvention().tagKey(StringEscapeUtils.escapeJson((String)key)) + "\":\"" + this.config().namingConvention().tagValue(StringEscapeUtils.escapeJson((String)tag.getValue())) + "\"";
            }).collect(Collectors.joining(",")));
        }
        sb.append("}}");
        return sb.toString();
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    static /* synthetic */ ThreadFactory access$000() {
        return DEFAULT_THREAD_FACTORY;
    }

    public static class Builder {
        private final AppOpticsConfig config;
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = AppOpticsMeterRegistry.access$000();
        private HttpSender httpClient;

        Builder(AppOpticsConfig config) {
            this.config = config;
            this.httpClient = new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout());
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder httpClient(HttpSender httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public AppOpticsMeterRegistry build() {
            return new AppOpticsMeterRegistry(this.config, this.clock, this.threadFactory, this.httpClient);
        }
    }

    private static enum Fields {
        Value("value"),
        Count("count"),
        Sum("sum"),
        Max("max"),
        Last("last");

        private final String tag;

        private Fields(String tag) {
            this.tag = tag;
        }

        String tag() {
            return this.tag;
        }
    }
}

