/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.appoptics;

import io.micrometer.core.instrument.config.MissingRequiredConfigurationException;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.lang.Nullable;
import java.time.Duration;

public interface AppOpticsConfig
extends StepRegistryConfig {
    public static final int MAX_BATCH_SIZE = 1000;
    public static final int DEFAULT_BATCH_SIZE = 500;

    default public String prefix() {
        return "appoptics";
    }

    default public String apiToken() {
        String t = this.get(this.prefix() + ".apiToken");
        if (null == t) {
            throw new MissingRequiredConfigurationException("token must be set to report metrics to AppOptics");
        }
        return t;
    }

    @Nullable
    default public String hostTag() {
        String v = this.get(this.prefix() + ".hostTag");
        return v == null ? "instance" : v;
    }

    default public String uri() {
        String v = this.get(this.prefix() + ".uri");
        return v == null ? "https://api.appoptics.com/v1/measurements" : v;
    }

    default public int batchSize() {
        String v = this.get(this.prefix() + ".batchSize");
        return null == v ? 500 : Math.min(Integer.parseInt(v), 1000);
    }

    @Deprecated
    default public Duration connectTimeout() {
        String v = this.get(this.prefix() + ".connectTimeout");
        return v == null ? Duration.ofSeconds(5L) : Duration.parse(v);
    }
}

