/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation.tck;

import io.micrometer.common.KeyValue;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.tck.ObservationContextAssert;
import io.micrometer.observation.tck.ObservationRegistryAssert;
import io.micrometer.observation.tck.TestObservationRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.assertj.core.api.ThrowingConsumer;

public class TestObservationRegistryAssert
extends ObservationRegistryAssert<TestObservationRegistryAssert, TestObservationRegistry> {
    protected TestObservationRegistryAssert(TestObservationRegistry actual) {
        super(actual, TestObservationRegistryAssert.class);
    }

    public static TestObservationRegistryAssert assertThat(TestObservationRegistry actual) {
        return new TestObservationRegistryAssert(actual);
    }

    public static TestObservationRegistryAssert then(TestObservationRegistry actual) {
        return new TestObservationRegistryAssert(actual);
    }

    public TestObservationRegistryAssertReturningObservationContextAssert hasSingleObservationThat() {
        Queue<TestObservationRegistry.TestObservationContext> contexts = ((TestObservationRegistry)this.actual).getContexts();
        if (contexts.isEmpty()) {
            this.failForNoObservations();
        } else if (contexts.size() != 1) {
            this.failWithMessage("There must be only a single observation, however there are <%s> registered observations with names <%s>", new Object[]{contexts.size(), this.observationNames(contexts)});
        }
        return new TestObservationRegistryAssertReturningObservationContextAssert(contexts.peek(), this);
    }

    private void failForNoObservations() {
        this.failWithMessage("There are no observations registered. You have forgotten to start your observation. Remember to call <observation.start()> method", new Object[0]);
    }

    public That hasObservationWithNameEqualTo(String name) {
        Queue<TestObservationRegistry.TestObservationContext> contexts = ((TestObservationRegistry)this.actual).getContexts();
        if (contexts.isEmpty()) {
            this.failForNoObservations();
        }
        TestObservationRegistry.TestObservationContext testObservationContext = contexts.stream().filter(mock -> Objects.equals(name, mock.getContext().getName())).findFirst().orElseGet(() -> {
            this.failWithMessage("There are no observations with name equal to <%s>. Available names are <%s>", new Object[]{name, this.observationNames(contexts)});
            return null;
        });
        return new That(testObservationContext, this);
    }

    private String observationNames(Queue<TestObservationRegistry.TestObservationContext> contexts) {
        return contexts.stream().map(m -> m.getContext().getName()).collect(Collectors.joining(","));
    }

    private String observations() {
        return ((TestObservationRegistry)this.actual).getContexts().stream().map(m -> m.getContext().toString()).collect(Collectors.joining(","));
    }

    public That hasObservationWithNameEqualToIgnoringCase(String name) {
        Queue<TestObservationRegistry.TestObservationContext> contexts = ((TestObservationRegistry)this.actual).getContexts();
        if (contexts.isEmpty()) {
            this.failForNoObservations();
        }
        TestObservationRegistry.TestObservationContext testObservationContext = contexts.stream().filter(mock -> name != null && name.equalsIgnoreCase(mock.getContext().getName())).findFirst().orElseGet(() -> {
            this.failWithMessage("There are no observations with name equal to ignoring case <%s>. Available names are <%s>", new Object[]{name, this.observationNames(contexts)});
            return null;
        });
        return new That(testObservationContext, this);
    }

    public void doesNotHaveAnyObservation() {
        Queue<TestObservationRegistry.TestObservationContext> contexts = ((TestObservationRegistry)this.actual).getContexts();
        if (!contexts.isEmpty()) {
            this.failWithMessage("There were <%d> observation(s) registered in the registry, expected <0>.", new Object[]{contexts.size()});
        }
    }

    public TestObservationRegistryAssert hasHandledContextsThatSatisfy(ThrowingConsumer<List<Observation.Context>> contextConsumer) {
        this.isNotNull();
        contextConsumer.accept(((TestObservationRegistry)this.actual).getContexts().stream().map(TestObservationRegistry.TestObservationContext::getContext).collect(Collectors.toList()));
        return this;
    }

    public TestObservationRegistryAssert forAllObservationsWithNameEqualTo(String name, Consumer<ObservationContextAssert> observationConsumer) {
        this.isNotNull();
        this.hasObservationWithNameEqualTo(name);
        ((TestObservationRegistry)this.actual).getContexts().stream().filter(f -> name.equals(f.getContext().getName())).forEach(f -> observationConsumer.accept(ObservationContextAssert.then((Observation.ContextView)f.getContext())));
        return this;
    }

    public TestObservationRegistryAssert forAllObservationsWithNameEqualToIgnoreCase(String name, Consumer<ObservationContextAssert> observationConsumer) {
        this.isNotNull();
        this.hasObservationWithNameEqualToIgnoringCase(name);
        ((TestObservationRegistry)this.actual).getContexts().stream().filter(f -> name.equalsIgnoreCase(f.getContext().getName())).forEach(f -> observationConsumer.accept(ObservationContextAssert.then((Observation.ContextView)f.getContext())));
        return this;
    }

    public TestObservationRegistryAssert hasNumberOfObservationsEqualTo(int expectedNumberOfObservations) {
        this.isNotNull();
        if (((TestObservationRegistry)this.actual).getContexts().size() != expectedNumberOfObservations) {
            this.failWithMessage("There should be <%s> Observations but there were <%s>. Found following Observations:\n%s", new Object[]{expectedNumberOfObservations, ((TestObservationRegistry)this.actual).getContexts().size(), this.observationNames(((TestObservationRegistry)this.actual).getContexts())});
        }
        return this;
    }

    public TestObservationRegistryAssert hasNumberOfObservationsWithNameEqualTo(String observationName, int expectedNumberOfObservations) {
        this.isNotNull();
        long observationsWithNameSize = ((TestObservationRegistry)this.actual).getContexts().stream().filter(f -> observationName.equals(f.getContext().getName())).count();
        if (observationsWithNameSize != (long)expectedNumberOfObservations) {
            this.failWithMessage("There should be <%s> Observations with name <%s> but there were <%s>. Found following Observations:\n%s", new Object[]{expectedNumberOfObservations, observationName, observationsWithNameSize, this.observationNames(((TestObservationRegistry)this.actual).getContexts())});
        }
        return this;
    }

    public TestObservationRegistryAssert hasNumberOfObservationsWithNameEqualToIgnoreCase(String observationName, int expectedNumberOfObservations) {
        this.isNotNull();
        long observationsWithNameSize = ((TestObservationRegistry)this.actual).getContexts().stream().filter(f -> observationName.equalsIgnoreCase(f.getContext().getName())).count();
        if (observationsWithNameSize != (long)expectedNumberOfObservations) {
            this.failWithMessage("There should be <%s> Observations with name (ignoring case) <%s> but there were <%s>. Found following Observations:\n%s", new Object[]{expectedNumberOfObservations, observationName, observationsWithNameSize, this.observationNames(((TestObservationRegistry)this.actual).getContexts())});
        }
        return this;
    }

    public TestObservationRegistryAssert hasAnObservationWithAKeyValue(String key, String value) {
        this.isNotNull();
        ((TestObservationRegistry)this.actual).getContexts().stream().flatMap(f -> f.getContext().getAllKeyValues().stream()).filter(keyValue -> keyValue.getKey().equals(key) && keyValue.getValue().equals(value)).findFirst().orElseThrow(() -> {
            this.failWithMessage("There should be at least one Observation with key name <%s> and value <%s> but found none. Found following Observations:\n%s", new Object[]{key, value, this.observations()});
            return new AssertionError();
        });
        return this;
    }

    public TestObservationRegistryAssert hasAnObservationWithAKeyValue(KeyValue keyValue) {
        return this.hasAnObservationWithAKeyValue(keyValue.getKey(), keyValue.getValue());
    }

    public TestObservationRegistryAssert hasAnObservationWithAKeyName(String key) {
        this.isNotNull();
        ((TestObservationRegistry)this.actual).getContexts().stream().flatMap(f -> f.getContext().getAllKeyValues().stream()).filter(keyValue -> keyValue.getKey().equals(key)).findFirst().orElseThrow(() -> {
            this.failWithMessage("There should be at least one Observation with key name <%s> but found none. Found following Observations:\n%s", new Object[]{key, this.observations()});
            return new AssertionError();
        });
        return this;
    }

    public TestObservationRegistryAssert hasAnObservationWithAKeyValue(KeyName key, String value) {
        return this.hasAnObservationWithAKeyValue(key.asString(), value);
    }

    public TestObservationRegistryAssert hasAnObservationWithAKeyName(KeyName key) {
        return this.hasAnObservationWithAKeyName(key.asString());
    }

    public TestObservationRegistryAssert hasAnObservation(Consumer<ObservationContextAssert> observationConsumer) {
        this.isNotNull();
        Queue<TestObservationRegistry.TestObservationContext> contexts = ((TestObservationRegistry)this.actual).getContexts();
        for (TestObservationRegistry.TestObservationContext context : contexts) {
            try {
                observationConsumer.accept(ObservationContextAssert.then((Observation.ContextView)context.getContext()));
                return this;
            }
            catch (AssertionError assertionError) {
            }
        }
        this.failWithMessage("There should be at least one Observation that matches the assertion. Found following Observations:\n%s", new Object[]{this.observations()});
        return this;
    }

    public static final class TestObservationRegistryAssertReturningObservationContextAssert
    extends ObservationContextAssert<TestObservationRegistryAssertReturningObservationContextAssert> {
        private final TestObservationRegistryAssert originalAssert;
        private final TestObservationRegistry.TestObservationContext testContext;

        private TestObservationRegistryAssertReturningObservationContextAssert(TestObservationRegistry.TestObservationContext testContext, TestObservationRegistryAssert observationContextAssert) {
            super((Observation.ContextView)testContext.getContext());
            this.testContext = testContext;
            this.originalAssert = observationContextAssert;
        }

        public TestObservationRegistryAssertReturningObservationContextAssert hasBeenStarted() {
            this.isNotNull();
            if (!this.testContext.isObservationStarted()) {
                this.failWithMessage("Observation is not started", new Object[0]);
            }
            return this;
        }

        public TestObservationRegistryAssertReturningObservationContextAssert hasBeenStopped() {
            this.isNotNull();
            if (!this.testContext.isObservationStopped()) {
                this.failWithMessage("Observation is not stopped", new Object[0]);
            }
            return this;
        }

        public TestObservationRegistryAssertReturningObservationContextAssert isNotStarted() {
            this.isNotNull();
            if (this.testContext.isObservationStarted()) {
                this.failWithMessage("Observation is started", new Object[0]);
            }
            return this;
        }

        public TestObservationRegistryAssertReturningObservationContextAssert isNotStopped() {
            this.isNotNull();
            if (this.testContext.isObservationStopped()) {
                this.failWithMessage("Observation is stopped", new Object[0]);
            }
            return this;
        }

        public TestObservationRegistryAssert backToTestObservationRegistry() {
            return this.originalAssert;
        }
    }

    public static final class That {
        private final TestObservationRegistryAssert originalAssert;
        private final TestObservationRegistry.TestObservationContext testContext;

        private That(TestObservationRegistry.TestObservationContext testContext, TestObservationRegistryAssert observationContextAssert) {
            this.testContext = testContext;
            this.originalAssert = observationContextAssert;
        }

        public TestObservationRegistryAssertReturningObservationContextAssert that() {
            return new TestObservationRegistryAssertReturningObservationContextAssert(this.testContext, this.originalAssert);
        }
    }
}

