/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.spans;

import io.micrometer.docs.commons.EventEntry;
import io.micrometer.docs.commons.KeyNameEntry;
import io.micrometer.docs.commons.utils.Assert;
import io.micrometer.docs.commons.utils.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

class SpanEntry
implements Comparable<SpanEntry> {
    final String name;
    final String nameOrigin;
    final String enclosingClass;
    final String enumName;
    final String description;
    final String prefix;
    final List<KeyNameEntry> tagKeys;
    final List<EventEntry> events;

    SpanEntry(String name, String nameOrigin, String enclosingClass, String enumName, String description, String prefix, List<KeyNameEntry> tagKeys, List<EventEntry> events) {
        Assert.hasText(description, "Span javadoc description must not be empty");
        this.nameOrigin = nameOrigin;
        this.name = name;
        this.enclosingClass = enclosingClass;
        this.enumName = enumName;
        this.description = description;
        this.prefix = prefix;
        this.tagKeys = tagKeys;
        this.events = events;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpanEntry spanEntry = (SpanEntry)o;
        return Objects.equals(this.name, spanEntry.name) && Objects.equals(this.nameOrigin, spanEntry.nameOrigin) && Objects.equals(this.enclosingClass, spanEntry.enclosingClass) && Objects.equals(this.enumName, spanEntry.enumName) && Objects.equals(this.description, spanEntry.description) && Objects.equals(this.prefix, spanEntry.prefix) && Objects.equals(this.tagKeys, spanEntry.tagKeys) && Objects.equals(this.events, spanEntry.events);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.nameOrigin, this.enclosingClass, this.enumName, this.description, this.prefix, this.tagKeys, this.events);
    }

    @Override
    public int compareTo(SpanEntry o) {
        return this.enumName.compareTo(o.enumName);
    }

    public String getSpanTitle() {
        String name = Arrays.stream(this.enumName.replace("_", " ").split(" ")).map(s -> StringUtils.capitalize(s.toLowerCase(Locale.ROOT))).collect(Collectors.joining(" "));
        if (!name.toLowerCase(Locale.ROOT).endsWith("span")) {
            return name + " Span";
        }
        return name;
    }

    public String getDisplayName() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.hasText(this.name)) {
            sb.append("`");
            sb.append(this.name);
            sb.append("`");
            if (StringUtils.hasText(this.nameOrigin)) {
                sb.append(" (defined by convention class `");
                sb.append(this.nameOrigin);
                sb.append("`)");
            }
        } else {
            sb.append("Unable to resolve the name - please check the convention class `");
            sb.append(this.nameOrigin);
            sb.append("` for more details");
        }
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getEnumName() {
        return this.enumName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEnclosingClass() {
        return this.enclosingClass;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public List<KeyNameEntry> getTagKeys() {
        return this.tagKeys;
    }

    public List<EventEntry> getEvents() {
        return this.events;
    }
}

