/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.conventions;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.docs.commons.JavaSourceSearchHelper;
import io.micrometer.docs.conventions.ObservationConventionEntry;
import io.micrometer.observation.GlobalObservationConvention;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.TypeHolderSource;

class ObservationConventionSearchingFileVisitor
extends SimpleFileVisitor<Path> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ObservationConventionSearchingFileVisitor.class);
    private final Pattern pattern;
    private final Collection<ObservationConventionEntry> observationConventionEntries;
    private final JavaSourceSearchHelper searchHelper;

    ObservationConventionSearchingFileVisitor(Pattern pattern, Collection<ObservationConventionEntry> observationConventionEntries, JavaSourceSearchHelper searchHelper) {
        this.pattern = pattern;
        this.observationConventionEntries = observationConventionEntries;
        this.searchHelper = searchHelper;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
        if (!this.pattern.matcher(path.toString()).matches()) {
            return FileVisitResult.CONTINUE;
        }
        if (!path.toString().endsWith(".java")) {
            return FileVisitResult.CONTINUE;
        }
        logger.debug("Parsing [" + path + "]");
        JavaSource javaSource = (JavaSource)Roaster.parse(JavaSource.class, (File)path.toFile());
        List<JavaClassSource> candidates = this.getCandidates(javaSource);
        if (candidates.isEmpty()) {
            return FileVisitResult.CONTINUE;
        }
        for (JavaClassSource candidate : candidates) {
            this.process(candidate);
        }
        return FileVisitResult.CONTINUE;
    }

    private List<JavaClassSource> getCandidates(JavaSource<?> javaSource) {
        ArrayList<JavaClassSource> candidates = new ArrayList<JavaClassSource>();
        if (javaSource.isClass()) {
            candidates.add((JavaClassSource)javaSource);
        }
        if (javaSource instanceof TypeHolderSource) {
            for (JavaSource nestedType : ((TypeHolderSource)javaSource).getNestedTypes()) {
                if (!nestedType.isClass()) continue;
                candidates.add((JavaClassSource)nestedType);
            }
        }
        return candidates;
    }

    private void process(JavaClassSource javaSource) {
        String interfaceName = this.searchHelper.searchObservationConventionInterfaceName((JavaSource<?>)javaSource);
        if (interfaceName == null) {
            return;
        }
        boolean isGlobal = interfaceName.startsWith(GlobalObservationConvention.class.getName());
        String canonicalName = javaSource.getCanonicalName();
        Pattern classPattern = Pattern.compile("^.*ObservationConvention<(.*)>$");
        String conventionContextName = this.contextClassName(classPattern, interfaceName);
        if (isGlobal) {
            this.observationConventionEntries.add(new ObservationConventionEntry(canonicalName, ObservationConventionEntry.Type.GLOBAL, conventionContextName));
        } else {
            this.observationConventionEntries.add(new ObservationConventionEntry(canonicalName, ObservationConventionEntry.Type.LOCAL, conventionContextName));
        }
    }

    private String contextClassName(Pattern classPattern, String anInterface) {
        Matcher matcher = classPattern.matcher(anInterface);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        if (!anInterface.contains("<") && !anInterface.contains(">")) {
            return "n/a";
        }
        return "";
    }
}

