/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.commons.utils;

import io.micrometer.common.lang.Nullable;
import io.micrometer.docs.commons.utils.StringUtils;

public final class Assert {
    public static void hasText(String text, String description) {
        if (!StringUtils.hasText(text)) {
            throw new IllegalArgumentException(description);
        }
    }

    public static void notNull(@Nullable Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isInstanceOf(Class<?> type, @Nullable Object obj) {
        Assert.isInstanceOf(type, obj, obj + " must be an instance of " + type);
    }

    public static void isInstanceOf(Class<?> type, @Nullable Object obj, String message) {
        Assert.notNull(type, "Type to check against must not be null");
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException(message);
        }
    }
}

