/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.commons;

import io.micrometer.common.docs.KeyName;
import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.docs.commons.EntryEnumConstantReader;
import io.micrometer.docs.commons.utils.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.BooleanLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodInvocation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.QualifiedName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ReturnStatement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.StringLiteral;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TypeLiteral;
import org.jboss.forge.roaster.model.source.EnumConstantSource;
import org.jboss.forge.roaster.model.source.JavaEnumSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class ParsingUtils {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ParsingUtils.class);

    public static <T> List<T> retrieveModelsFromEnum(JavaEnumSource enumSource, EntryEnumConstantReader<?> converter) {
        if (!enumSource.hasInterface(converter.getRequiredClass().getSimpleName())) {
            return Collections.emptyList();
        }
        logger.debug("Checking [" + enumSource.getName() + "." + enumSource.getName() + "]");
        if (enumSource.getEnumConstants().size() == 0) {
            return Collections.emptyList();
        }
        ArrayList models = new ArrayList();
        for (EnumConstantSource enumConstant : enumSource.getEnumConstants()) {
            models.add(converter.apply(enumConstant));
        }
        return models;
    }

    public static String readStringReturnValue(MethodSource<?> methodSource) {
        return ParsingUtils.stringFromReturnMethodDeclaration(methodSource);
    }

    public static Set<String> readEnumClassNames(MethodSource<?> methodSource) {
        Expression expression = ParsingUtils.expressionFromReturnMethodDeclaration(methodSource);
        if (!(expression instanceof MethodInvocation)) {
            logger.warn("Statement [" + expression + "] is not a method invocation.");
            return Collections.emptySet();
        }
        MethodInvocation methodInvocation = (MethodInvocation)expression;
        if ("merge".equals(methodInvocation.getName().getIdentifier())) {
            String invocationString = methodInvocation.toString();
            Matcher matcher = Pattern.compile("([a-zA-Z]+.values)").matcher(invocationString);
            TreeSet<String> classNames = new TreeSet<String>();
            while (matcher.find()) {
                String className = matcher.group(1).split("\\.")[0];
                classNames.add(className);
            }
            return classNames;
        }
        if (!methodInvocation.toString().endsWith(".values()")) {
            throw new IllegalStateException("You have to use the static .values() method on the enum that implements " + KeyName.class + " interface or use [KeyName.merge(...)] method to merge multiple values from tags");
        }
        return Collections.singleton(methodInvocation.getExpression().toString());
    }

    @Nullable
    static String enumMethodValue(EnumConstantSource enumConstant, String methodName) {
        MethodSource methodSource = enumConstant.getBody().getMethod(methodName);
        if (methodSource == null) {
            logger.debug("Can't find the member with method name [" + methodName + "] on " + enumConstant.getName());
            return null;
        }
        return ParsingUtils.readStringReturnValue(methodSource);
    }

    private static String stringFromReturnMethodDeclaration(MethodSource<?> methodSource) {
        Expression expression = ParsingUtils.expressionFromReturnMethodDeclaration(methodSource);
        if (expression instanceof StringLiteral) {
            return ((StringLiteral)expression).getLiteralValue();
        }
        if (expression instanceof BooleanLiteral) {
            return Boolean.toString(((BooleanLiteral)expression).booleanValue());
        }
        if (expression instanceof TypeLiteral) {
            return ((TypeLiteral)expression).getType().toString();
        }
        if (expression instanceof QualifiedName) {
            return ((QualifiedName)expression).getName().toString();
        }
        logger.warn("Failed to retrieve string return value from [" + methodSource.getName() + "].");
        return "";
    }

    @Nullable
    public static Expression expressionFromReturnMethodDeclaration(MethodSource<?> methodSource) {
        MethodDeclaration methodDeclaration = ParsingUtils.getMethodDeclaration(methodSource);
        Object statement = methodDeclaration.getBody().statements().get(0);
        if (!(statement instanceof ReturnStatement)) {
            logger.warn("Statement [" + statement.getClass() + "] is not a return statement.");
            return null;
        }
        ReturnStatement returnStatement = (ReturnStatement)statement;
        return returnStatement.getExpression();
    }

    public static MethodDeclaration getMethodDeclaration(MethodSource<?> methodSource) {
        Object methodInternal = methodSource.getInternal();
        Assert.isInstanceOf(MethodDeclaration.class, methodInternal);
        return (MethodDeclaration)methodInternal;
    }
}

