/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.commons;

import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.docs.commons.utils.Assert;
import io.micrometer.observation.GlobalObservationConvention;
import io.micrometer.observation.ObservationConvention;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.QualifiedName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SimpleName;
import org.jboss.forge.roaster.model.Extendable;
import org.jboss.forge.roaster.model.InterfaceCapable;
import org.jboss.forge.roaster.model.source.EnumConstantSource;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.JavaEnumSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodHolderSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.TypeHolderSource;

public class JavaSourceSearchHelper {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(JavaSourceSearchHelper.class);
    private final Map<String, JavaSourcePathInfo> pathInfoMap;
    private final Map<String, Set<String>> qualifiedClassNames = new HashMap<String, Set<String>>();

    public static JavaSourceSearchHelper create(Path projectRoot, Pattern inclusionPattern) {
        PathCollectingFileVisitor visitor = new PathCollectingFileVisitor(inclusionPattern);
        try {
            long before = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            Files.walkFileTree(projectRoot, visitor);
            long after = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            logger.debug("Memory usage: before{}, after={}, diff={}", new Object[]{before, after, after - before});
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to parse java files.", ex);
        }
        return JavaSourceSearchHelper.create(visitor.getMap());
    }

    static JavaSourceSearchHelper create(Map<String, JavaSourcePathInfo> map) {
        return new JavaSourceSearchHelper(map);
    }

    private JavaSourceSearchHelper(Map<String, JavaSourcePathInfo> pathInfoMap) {
        this.pathInfoMap = pathInfoMap;
        for (Map.Entry<String, JavaSourcePathInfo> entry : pathInfoMap.entrySet()) {
            String qualifiedName = entry.getKey();
            String canonicalName = entry.getValue().canonicalName;
            this.qualifiedClassNames.compute(canonicalName, (key, set) -> {
                if (set == null) {
                    return Collections.singleton(qualifiedName);
                }
                HashSet<String> newSet = new HashSet<String>((Collection<String>)set);
                newSet.add(qualifiedName);
                return newSet;
            });
        }
    }

    @Nullable
    public JavaSource<?> search(String qualifiedName) {
        JavaSourcePathInfo info;
        boolean isGeneric = qualifiedName.contains("<");
        String resolvedName = qualifiedName;
        if (isGeneric) {
            resolvedName = qualifiedName.substring(0, qualifiedName.indexOf("<"));
        }
        if ((info = this.pathInfoMap.get(resolvedName)) == null) {
            return null;
        }
        return info.getJavaSource();
    }

    @Nullable
    public JavaSource<?> searchReferencingClass(JavaSource<?> enclosingJavaSource, String className) {
        JavaSource<?> javaSource = this.search(className);
        if (javaSource != null) {
            return javaSource;
        }
        String enclosingClassSimpleName = enclosingJavaSource.getName();
        if (className.startsWith(enclosingClassSimpleName + ".")) {
            className = className.substring(enclosingClassSimpleName.length() + 1);
        }
        if (enclosingJavaSource instanceof TypeHolderSource) {
            for (JavaSource nestedType : ((TypeHolderSource)enclosingJavaSource).getNestedTypes()) {
                String simpleName = nestedType.getName();
                String canonicalName = nestedType.getCanonicalName();
                String qualifiedName = nestedType.getQualifiedName();
                if (className.equals(simpleName) || className.equals(canonicalName) || className.equals(qualifiedName)) {
                    return nestedType;
                }
                JavaSource<?> source = this.searchReferencingClass(nestedType, className);
                if (source == null) continue;
                return source;
            }
        }
        for (Import anImport : enclosingJavaSource.getImports()) {
            if (anImport.isStatic()) continue;
            if (anImport.isWildcard()) {
                JavaSource<?> match = this.searchWithinPackage(anImport.getPackage(), className);
                if (match == null) continue;
                return match;
            }
            if (!anImport.getQualifiedName().equals(className) && !anImport.getSimpleName().equals(className)) continue;
            return this.search(anImport.getQualifiedName());
        }
        String packageName = enclosingJavaSource.getPackage();
        JavaSource<?> match = this.searchWithinPackage(packageName, className);
        if (match != null) {
            return match;
        }
        return null;
    }

    @Nullable
    private JavaSource<?> searchWithinPackage(String packageName, String className) {
        if ("".equals(packageName)) {
            return this.search(className);
        }
        for (String qualifiedName : this.pathInfoMap.keySet()) {
            if (!qualifiedName.contains(".") || className.contains("$") && !qualifiedName.contains("$")) continue;
            int index = qualifiedName.lastIndexOf(".");
            String entryPackage = qualifiedName.substring(0, index);
            String entryClassName = qualifiedName.substring(index + 1);
            if (!packageName.equals(entryPackage) || !entryClassName.equals(className)) continue;
            return this.search(qualifiedName);
        }
        return null;
    }

    @Nullable
    public EnumConstantSource searchReferencingEnumConstant(JavaSource<?> enclosingJavaSource, Expression expression) {
        if (expression instanceof QualifiedName) {
            QualifiedName qualifiedName = (QualifiedName)expression;
            String qualifier = qualifiedName.getQualifier().getFullyQualifiedName();
            String enumValue = qualifiedName.getName().getIdentifier();
            JavaSource<?> javaSource = this.searchReferencingClass(enclosingJavaSource, qualifier);
            if (javaSource == null) {
                return null;
            }
            if (!javaSource.isEnum()) {
                return null;
            }
            return ((JavaEnumSource)javaSource).getEnumConstant(enumValue);
        }
        if (expression instanceof SimpleName) {
            String enumConstantName = ((SimpleName)expression).getIdentifier();
            for (Import anImport : enclosingJavaSource.getImports()) {
                EnumConstantSource enumConstant;
                JavaSource<?> javaSource;
                if (!anImport.isStatic()) continue;
                if (anImport.isWildcard()) {
                    EnumConstantSource enumConstant2;
                    String enumClassCanonicalName = anImport.getPackage();
                    JavaSource<?> javaSource2 = this.searchByCanonicalName(enumClassCanonicalName);
                    if (javaSource2 == null || !javaSource2.isEnum() || (enumConstant2 = ((JavaEnumSource)javaSource2).getEnumConstant(enumConstantName)) == null) continue;
                    return enumConstant2;
                }
                if (!anImport.getSimpleName().equals(enumConstantName) || (javaSource = this.searchByCanonicalName(anImport.getPackage())) == null || !javaSource.isEnum() || (enumConstant = ((JavaEnumSource)javaSource).getEnumConstant(enumConstantName)) == null) continue;
                return enumConstant;
            }
        }
        return null;
    }

    @Nullable
    private JavaSource<?> searchByCanonicalName(String canonicalName) {
        Set<String> qualifiedNames = this.qualifiedClassNames.get(canonicalName);
        if (qualifiedNames == null) {
            return null;
        }
        for (String qualifiedName : qualifiedNames) {
            JavaSource<?> javaSource = this.search(qualifiedName);
            if (javaSource == null) continue;
            return javaSource;
        }
        return null;
    }

    @Nullable
    public MethodSource<?> searchMethodSource(JavaSource<?> javaSource, String methodName) {
        Assert.isInstanceOf(MethodHolderSource.class, javaSource);
        MethodSource<?> methodSource = ((MethodHolderSource)javaSource).getMethod(methodName);
        if (methodSource != null) {
            return methodSource;
        }
        if (javaSource instanceof Extendable) {
            String parentClassName = ((Extendable)javaSource).getSuperType();
            if (!Object.class.getName().equals(parentClassName)) {
                JavaSource<?> parentSource = this.searchJavaSourceByRoasterTypeName(javaSource, parentClassName);
                if (parentSource != null) {
                    methodSource = this.searchMethodSource(parentSource, methodName);
                }
                if (methodSource != null) {
                    return methodSource;
                }
            }
        }
        if (javaSource instanceof InterfaceCapable) {
            List interfaces = ((InterfaceCapable)javaSource).getInterfaces();
            for (String interfaceName : interfaces) {
                JavaSource<?> interfaceSource = this.searchJavaSourceByRoasterTypeName(javaSource, interfaceName);
                if (interfaceSource != null) {
                    methodSource = this.searchMethodSource(interfaceSource, methodName);
                }
                if (methodSource == null) continue;
                return methodSource;
            }
        }
        return null;
    }

    @Nullable
    private JavaSource<?> searchJavaSourceByRoasterTypeName(JavaSource<?> enclosingJavaSource, String typeName) {
        ArrayList<String> candidateNames = new ArrayList<String>();
        candidateNames.add(typeName);
        String packageName = enclosingJavaSource.getPackage();
        if (typeName.contains(packageName)) {
            String targetClassName = typeName.substring(0, packageName.length());
            String qualifiedName = enclosingJavaSource.getQualifiedName() + "$" + targetClassName;
            candidateNames.add(targetClassName);
            candidateNames.add(qualifiedName);
        }
        for (String candidate : candidateNames) {
            JavaSource<?> javaSource = this.searchReferencingClass(enclosingJavaSource, candidate);
            if (javaSource == null) continue;
            return javaSource;
        }
        return null;
    }

    @Nullable
    public String searchObservationConventionInterfaceName(JavaSource<?> javaSource) {
        return this.searchObservationConventionInterfaceName(javaSource, new HashSet<String>());
    }

    @Nullable
    private String searchObservationConventionInterfaceName(JavaSource<?> javaSource, Set<String> visited) {
        String result;
        String qualifiedName = javaSource.getQualifiedName();
        logger.trace("Searching ObservationConvention on {} - start", (Object)qualifiedName);
        if (visited.contains(qualifiedName)) {
            return null;
        }
        visited.add(qualifiedName);
        if (javaSource instanceof InterfaceCapable) {
            List interfaces = ((InterfaceCapable)javaSource).getInterfaces();
            Iterator iterator = interfaces.iterator();
            while (iterator.hasNext()) {
                String result2;
                String interfaceName = (String)iterator.next();
                if (interfaceName.contains(ObservationConvention.class.getCanonicalName()) || interfaceName.contains(GlobalObservationConvention.class.getCanonicalName())) {
                    return interfaceName;
                }
                JavaSource<?> interfaceSource = this.searchJavaSourceByRoasterTypeName(javaSource, interfaceName);
                if (interfaceSource == null || (result2 = this.searchObservationConventionInterfaceName(interfaceSource, visited)) == null) continue;
                return result2;
            }
        }
        if (javaSource instanceof TypeHolderSource) {
            for (JavaSource nested : ((TypeHolderSource)javaSource).getNestedTypes()) {
                result = this.searchObservationConventionInterfaceName(nested, visited);
                if (result == null) continue;
                return result;
            }
        }
        if (javaSource instanceof Extendable) {
            JavaSource<?> parentSource;
            String parentClassName = ((Extendable)javaSource).getSuperType();
            if (!Object.class.getName().equals(parentClassName) && (parentSource = this.searchJavaSourceByRoasterTypeName(javaSource, parentClassName)) != null && (result = this.searchObservationConventionInterfaceName(parentSource, visited)) != null) {
                return result;
            }
        }
        logger.trace("Searching ObservationConvention on {} - not found", (Object)qualifiedName);
        return null;
    }

    static class PathCollectingFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Pattern pattern;
        private final Map<String, JavaSourcePathInfo> map = new HashMap<String, JavaSourcePathInfo>();

        PathCollectingFileVisitor(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            if (!this.pattern.matcher(path.toString()).matches()) {
                return FileVisitResult.CONTINUE;
            }
            if (!path.toString().endsWith(".java")) {
                return FileVisitResult.CONTINUE;
            }
            if (path.toString().endsWith("package-info.java") || path.toString().endsWith("module-info.java")) {
                return FileVisitResult.CONTINUE;
            }
            JavaSource javaSource = (JavaSource)Roaster.parse(JavaSource.class, (File)path.toFile());
            ArrayList sources = new ArrayList();
            this.populateJavaSource(javaSource, sources);
            for (JavaSource javaSource2 : sources) {
                String canonicalName = javaSource2.getCanonicalName();
                String qualifiedName = javaSource2.getQualifiedName();
                String simpleName = javaSource2.getName();
                this.map.put(qualifiedName, new JavaSourcePathInfo(path, canonicalName, qualifiedName, simpleName));
            }
            return FileVisitResult.CONTINUE;
        }

        public Map<String, JavaSourcePathInfo> getMap() {
            return this.map;
        }

        private void populateJavaSource(JavaSource<?> javaSource, List<JavaSource<?>> list) {
            list.add(javaSource);
            if (javaSource instanceof TypeHolderSource) {
                for (JavaSource nested : ((TypeHolderSource)javaSource).getNestedTypes()) {
                    this.populateJavaSource(nested, list);
                }
            }
        }
    }

    static class JavaSourcePathInfo {
        final Path path;
        final String canonicalName;
        final String qualifiedName;
        final String simpleName;

        public JavaSourcePathInfo(Path path, String canonicalName, String qualifiedName, String simpleName) {
            this.path = path;
            this.canonicalName = canonicalName;
            this.qualifiedName = qualifiedName;
            this.simpleName = simpleName;
        }

        JavaSource<?> getJavaSource() {
            JavaSource javaSource;
            try {
                javaSource = (JavaSource)Roaster.parse(JavaSource.class, (File)this.path.toFile());
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to parse " + this.path, ex);
            }
            JavaSource<?> result = this.findJavaSource(javaSource, this.qualifiedName);
            if (result == null) {
                throw new RuntimeException(String.format("Could not find %s in %s", this.qualifiedName, this.path));
            }
            return result;
        }

        @Nullable
        private JavaSource<?> findJavaSource(JavaSource<?> javaSource, String qualifiedName) {
            if (javaSource.getQualifiedName().equals(qualifiedName)) {
                return javaSource;
            }
            if (javaSource instanceof TypeHolderSource) {
                for (JavaSource nested : ((TypeHolderSource)javaSource).getNestedTypes()) {
                    JavaSource<?> result = this.findJavaSource(nested, qualifiedName);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }
    }
}

