/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.datadog;

import com.netflix.spectator.api.Registry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.NamingConvention;
import io.micrometer.core.instrument.spectator.step.StepSpectatorMeterRegistry;
import io.micrometer.datadog.DatadogConfig;
import io.micrometer.datadog.DatadogNamingConvention;
import io.micrometer.datadog.DatadogRegistry;

public class DatadogMeterRegistry
extends StepSpectatorMeterRegistry {
    public DatadogMeterRegistry(DatadogConfig config, final Clock clock) {
        super((Registry)new DatadogRegistry(config, new com.netflix.spectator.api.Clock(){

            public long wallTime() {
                return clock.wallTime();
            }

            public long monotonicTime() {
                return clock.monotonicTime();
            }
        }), clock, config.step().toMillis());
        this.config().namingConvention((NamingConvention)new DatadogNamingConvention());
        this.start();
    }

    public DatadogMeterRegistry(DatadogConfig config) {
        this(config, Clock.SYSTEM);
    }

    public void start() {
        this.getDatadogRegistry().start();
    }

    public void stop() {
        this.getDatadogRegistry().stop();
    }

    private DatadogRegistry getDatadogRegistry() {
        return (DatadogRegistry)this.getSpectatorRegistry();
    }
}

