/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.maven.provider.container;

import java.util.HashMap;
import java.util.Map;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

public class PostgreSQLPoolContainer
extends PostgreSQLContainer<PostgreSQLPoolContainer> {
    public static final String DEFAULT_IMAGE = "postgres:13.2";
    public static final String DEFAULT_USERNAME = "sa";
    public static final String DEFAULT_PASSWORD = "sa";
    public static final String DEFAULT_DATABASE_NAME = "postgres";

    public PostgreSQLPoolContainer() {
        this(DEFAULT_IMAGE);
    }

    public PostgreSQLPoolContainer(String imageName) {
        super(DockerImageName.parse((String)imageName).asCompatibleSubstituteFor(DEFAULT_IMAGE));
        this.withDatabaseName(DEFAULT_DATABASE_NAME);
        this.withUsername("sa");
        this.withPassword("sa");
    }

    public PostgreSQLPoolContainer withTmpFs(int liveTmpFsSizeInMB) {
        if (liveTmpFsSizeInMB != 0) {
            this.withEnv("PGDATA", "/live/pgdata");
            this.withTmpFs(this.tmpFs(liveTmpFsSizeInMB));
        }
        return this;
    }

    private Map<String, String> tmpFs(int liveSizeMB) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("/live", "rw,size=" + liveSizeMB + "m");
        return mapping;
    }

    public String getShortJdbcUrl() {
        return "jdbc:postgresql://" + this.getHost() + ":" + this.getMappedPort(POSTGRESQL_PORT) + "/";
    }

    public int getPort() {
        return this.getFirstMappedPort();
    }
}

