/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.test.provider.junit4;

import io.metaloom.test.container.provider.client.ClientAllocation;
import io.metaloom.test.container.provider.client.ProviderClient;
import io.metaloom.test.container.provider.common.ClientEnv;
import io.metaloom.test.container.provider.model.DatabaseAllocationResponse;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseProviderRule
implements TestRule {
    public static final Logger log = LoggerFactory.getLogger(DatabaseProviderRule.class);
    private ProviderClient client;
    private ClientAllocation allocation;

    public DatabaseProviderRule(String host, int port) {
        this.client = new ProviderClient(host, port);
    }

    public DatabaseProviderRule() {
        this(ClientEnv.getProviderHost(), ClientEnv.getProviderPort());
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                DatabaseProviderRule.this.starting(description);
                try {
                    base.evaluate();
                }
                finally {
                    DatabaseProviderRule.this.finished(description);
                }
            }
        };
    }

    protected void finished(Description description) {
        if (this.allocation != null) {
            this.allocation.release();
            this.allocation = null;
        }
    }

    protected void starting(Description description) {
        String testName = description.getMethodName();
        String testClass = description.getClassName();
        String testRef = testClass + "_" + testName;
        try {
            this.allocation = (ClientAllocation)this.client.link("default", testRef).get();
        }
        catch (Exception e) {
            log.error("Error while linking test {}", (Object)testRef, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public DatabaseAllocationResponse db() {
        return this.allocation == null ? null : this.allocation.response();
    }
}

