/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.test.container.provider.client;

import io.metaloom.test.container.provider.client.ClientAllocation;
import io.metaloom.test.container.provider.client.JSON;
import io.metaloom.test.container.provider.client.WebsocketLinkListener;
import io.metaloom.test.container.provider.model.DatabasePoolListResponse;
import io.metaloom.test.container.provider.model.DatabasePoolRequest;
import io.metaloom.test.container.provider.model.DatabasePoolResponse;
import io.metaloom.test.container.provider.model.RestModel;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderClient {
    public static final Logger log = LoggerFactory.getLogger(ProviderClient.class);
    private String host;
    private int port;
    private HttpClient client;

    public ProviderClient(String host, int port) {
        this.host = host;
        this.port = port;
        this.client = HttpClient.newBuilder().build();
    }

    public CompletableFuture<ClientAllocation> link(String poolName, String testRef) {
        WebsocketLinkListener listener = new WebsocketLinkListener(poolName, testRef);
        HttpClient.newHttpClient().newWebSocketBuilder().buildAsync(URI.create("ws://" + this.host + ":" + this.port + "/connect/websocket"), listener).join();
        return listener.allocation();
    }

    public CompletableFuture<DatabasePoolListResponse> listPools() throws URISyntaxException {
        HttpRequest request = HttpRequest.newBuilder().uri(this.uri("/pools")).version(HttpClient.Version.HTTP_2).GET().build();
        CompletableFuture<HttpResponse<String>> response = this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
        return ((CompletableFuture)response.thenApply(resp -> (String)resp.body())).thenApply(body -> JSON.fromString(body, DatabasePoolListResponse.class));
    }

    public CompletableFuture<DatabasePoolResponse> loadPool(String id) throws IOException, InterruptedException, URISyntaxException {
        HttpRequest request = HttpRequest.newBuilder().uri(this.uri("/pools/" + id)).version(HttpClient.Version.HTTP_2).GET().build();
        CompletableFuture<HttpResponse<String>> asyncResp = this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
        return ((CompletableFuture)asyncResp.thenApply(resp -> (String)resp.body())).thenApply(body -> JSON.fromString(body, DatabasePoolResponse.class));
    }

    public CompletableFuture<Void> deletePool(String id) throws URISyntaxException {
        HttpRequest request = HttpRequest.newBuilder().uri(this.uri("/pools/" + id)).version(HttpClient.Version.HTTP_2).DELETE().build();
        CompletableFuture<HttpResponse<Void>> response = this.client.sendAsync(request, HttpResponse.BodyHandlers.discarding());
        return response.thenApply(body -> (Void)body.body());
    }

    public CompletableFuture<DatabasePoolResponse> createPool(String id, DatabasePoolRequest request) throws URISyntaxException {
        String json = JSON.toString((RestModel)request);
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(this.uri("/pools/" + id)).version(HttpClient.Version.HTTP_2).POST(HttpRequest.BodyPublishers.ofString(json)).build();
        CompletableFuture<HttpResponse<String>> response = this.client.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString());
        return ((CompletableFuture)response.thenApply(resp -> (String)resp.body())).thenApply(body -> JSON.fromString(body, DatabasePoolResponse.class));
    }

    private URI uri(String path) throws URISyntaxException {
        return new URI("http", null, this.host, this.port, path, null, null);
    }
}

