/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.test.container.provider.client;

import io.metaloom.test.container.provider.client.ProviderClient;
import io.metaloom.test.container.provider.common.config.PostgresqlConfig;
import io.metaloom.test.container.provider.common.config.ProviderConfig;
import io.metaloom.test.container.provider.common.config.ProviderConfigHelper;
import io.metaloom.test.container.provider.model.DatabasePoolConnection;
import io.metaloom.test.container.provider.model.DatabasePoolRequest;
import io.metaloom.test.container.provider.model.DatabasePoolResponse;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class TestDatabaseProvider {
    public static ProviderClient client(String host, int port) {
        return new ProviderClient(host, port);
    }

    public static ProviderClient client() throws IOException {
        ProviderConfig config = TestDatabaseProvider.config();
        TestDatabaseProvider.requireConfig(config);
        String host = config.getProviderHost();
        int port = config.getProviderPort();
        return TestDatabaseProvider.client(host, port);
    }

    public static ProviderConfig config() {
        return ProviderConfigHelper.readConfig();
    }

    public static DatabasePoolResponse createPool(String poolName, String templateDatabaseName) throws Exception {
        ProviderConfig config = TestDatabaseProvider.config();
        TestDatabaseProvider.requireConfig(config);
        DatabasePoolRequest request = new DatabasePoolRequest();
        request.setTemplateDatabaseName(templateDatabaseName);
        DatabasePoolConnection connection = new DatabasePoolConnection(config.getPostgresql());
        request.setConnection(connection);
        ProviderClient client = TestDatabaseProvider.client();
        DatabasePoolResponse response = client.createPool(poolName, request).get();
        return response;
    }

    public static void createPostgreSQLDatabase(String name) throws SQLException {
        ProviderConfig config = TestDatabaseProvider.config();
        TestDatabaseProvider.requireConfig(config);
        PostgresqlConfig postgresConfig = config.getPostgresql();
        String sql = "CREATE DATABASE " + name;
        try (Connection connection = DriverManager.getConnection(config.getPostgresql().adminJdbcUrl(), postgresConfig.getUsername(), postgresConfig.getPassword());){
            Statement statement1 = connection.createStatement();
            statement1.execute(sql);
        }
    }

    public static void dropCreatePostgreSQLDatabase(String name) throws SQLException {
        ProviderConfig config = TestDatabaseProvider.config();
        TestDatabaseProvider.requireConfig(config);
        PostgresqlConfig postgresConfig = config.getPostgresql();
        String dropSQL = "DROP DATABASE IF EXISTS " + name;
        String createSQL = "CREATE DATABASE " + name;
        try (Connection connection = DriverManager.getConnection(config.getPostgresql().adminJdbcUrl(), postgresConfig.getUsername(), postgresConfig.getPassword());){
            connection.createStatement().execute(dropSQL);
            connection.createStatement().execute(createSQL);
        }
    }

    private static void requireConfig(ProviderConfig config) {
        if (config == null) {
            throw new RuntimeException("Unable to locate provider configuration file in filesystem. Started search here: " + String.valueOf(ProviderConfigHelper.currentConfigPath()));
        }
    }
}

