/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.client.http.model.collection;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.metaloom.qdrant.client.http.model.RestRequestModel;
import io.metaloom.qdrant.client.http.model.collection.InitFrom;
import io.metaloom.qdrant.client.http.model.collection.config.Distance;
import io.metaloom.qdrant.client.http.model.collection.config.HnswConfigDiff;
import io.metaloom.qdrant.client.http.model.collection.config.NamedVectorParams;
import io.metaloom.qdrant.client.http.model.collection.config.OptimizersConfigDiff;
import io.metaloom.qdrant.client.http.model.collection.config.VectorParams;
import io.metaloom.qdrant.client.http.model.collection.config.VectorsConfig;
import io.metaloom.qdrant.client.http.model.collection.config.WalConfigDiff;

public class CollectionCreateRequest
implements RestRequestModel {
    private VectorsConfig vectors;
    @JsonProperty(value="shard_number")
    private Integer shardNumber;
    @JsonProperty(value="replication_factor")
    private Integer replicationFactor;
    @JsonProperty(value="write_consistency_factor")
    private Integer writeConsistencyFactor;
    @JsonProperty(value="on_disk_payload")
    private Boolean onDiskPayload;
    @JsonProperty(value="hnsw_config")
    private HnswConfigDiff hnswConfig;
    @JsonProperty(value="wal_config")
    private WalConfigDiff walConfig;
    @JsonProperty(value="optimizers_config")
    private OptimizersConfigDiff optimizersConfig;
    @JsonProperty(value="init_from")
    private InitFrom initFrom;

    public VectorsConfig getVectors() {
        return this.vectors;
    }

    public CollectionCreateRequest setVectors(VectorsConfig vectors) {
        this.vectors = vectors;
        return this;
    }

    @JsonIgnore
    public CollectionCreateRequest setVectors(int size, Distance distance) {
        return this.setVectors(new VectorParams().setSize(size).setDistance(distance));
    }

    @JsonIgnore
    public NamedVectorParams setVectors(String name, int size, Distance distance) {
        NamedVectorParams params = NamedVectorParams.of(name, size, distance);
        this.setVectors(params);
        return params;
    }

    public Integer getShardNumber() {
        return this.shardNumber;
    }

    public CollectionCreateRequest setShardNumber(Integer shardNumber) {
        this.shardNumber = shardNumber;
        return this;
    }

    public Integer getWriteConsistencyFactor() {
        return this.writeConsistencyFactor;
    }

    public CollectionCreateRequest setWriteConsistencyFactor(Integer writeConsistencyFactor) {
        this.writeConsistencyFactor = writeConsistencyFactor;
        return this;
    }

    public Boolean getOnDiskPayload() {
        return this.onDiskPayload;
    }

    public CollectionCreateRequest setOnDiskPayload(Boolean onDiskPayload) {
        this.onDiskPayload = onDiskPayload;
        return this;
    }

    public HnswConfigDiff getHnswConfig() {
        return this.hnswConfig;
    }

    public CollectionCreateRequest setHnswConfig(HnswConfigDiff hnswConfig) {
        this.hnswConfig = hnswConfig;
        return this;
    }

    public WalConfigDiff getWalConfig() {
        return this.walConfig;
    }

    public CollectionCreateRequest setWalConfig(WalConfigDiff walConfig) {
        this.walConfig = walConfig;
        return this;
    }

    public OptimizersConfigDiff getOptimizersConfig() {
        return this.optimizersConfig;
    }

    public CollectionCreateRequest setOptimizersConfig(OptimizersConfigDiff optimizersConfig) {
        this.optimizersConfig = optimizersConfig;
        return this;
    }

    public InitFrom getInitFrom() {
        return this.initFrom;
    }

    public CollectionCreateRequest setInitFrom(InitFrom initFrom) {
        this.initFrom = initFrom;
        return this;
    }
}

