/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.client.json.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.metaloom.qdrant.client.http.model.collection.filter.Filter;
import io.metaloom.qdrant.client.http.model.collection.filter.condition.Condition;
import io.metaloom.qdrant.client.http.model.collection.filter.condition.FieldCondition;
import io.metaloom.qdrant.client.http.model.collection.filter.condition.HasIdCondition;
import io.metaloom.qdrant.client.http.model.collection.filter.condition.IsEmptyCondition;
import java.io.IOException;

public class ConditionDeserializer
extends JsonDeserializer<Condition> {
    public Condition deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jsonParser);
        ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
        if (node.has("is_empty")) {
            return (Condition)mapper.convertValue((Object)node, IsEmptyCondition.class);
        }
        if (node.has("has_id")) {
            return (Condition)mapper.convertValue((Object)node, HasIdCondition.class);
        }
        if (node.has("key")) {
            return (Condition)mapper.convertValue((Object)node, FieldCondition.class);
        }
        if (node.has("should") || node.has("must") || node.has("must_not")) {
            return (Condition)mapper.convertValue((Object)node, Filter.class);
        }
        throw new RuntimeException("Error while deserializing JSON. Unable to find condition implementation for " + node.toPrettyString());
    }
}

