/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.client.json.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.metaloom.qdrant.client.http.model.point.VectorData;
import io.metaloom.qdrant.client.http.model.point.VectorDataMap;
import io.metaloom.qdrant.client.http.model.point.VectorDataPlain;
import java.io.IOException;
import java.util.ArrayList;

public class VectorDataDeserializer
extends JsonDeserializer<VectorData> {
    public VectorData deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jsonParser);
        ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
        if (node.isObject()) {
            return (VectorData)mapper.convertValue((Object)node, VectorDataMap.class);
        }
        VectorDataPlain vector = new VectorDataPlain();
        ArrayList<Float> vectorData = new ArrayList<Float>();
        for (int i = 0; i < node.size(); ++i) {
            JsonNode number = node.get(i);
            if (!number.isNumber()) {
                throw new RuntimeException("Vector component could not be parsed. Unsupported value type encountered. Got: " + number.getNodeType());
            }
            vectorData.add(Float.valueOf((float)number.asDouble()));
        }
        vector.setVector(vectorData);
        return vector;
    }
}

