/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.client.json.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.metaloom.qdrant.client.http.model.point.BatchVectorData;
import io.metaloom.qdrant.client.http.model.point.BatchVectorDataMap;
import io.metaloom.qdrant.client.http.model.point.BatchVectorDataPlain;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BatchVectorDataSerializer
extends JsonSerializer<BatchVectorData> {
    public void serialize(BatchVectorData value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value instanceof BatchVectorDataMap) {
            BatchVectorDataMap mapData = (BatchVectorDataMap)value;
            gen.writeStartObject();
            for (Map.Entry entry : mapData.entrySet()) {
                String name = (String)entry.getKey();
                gen.writeArrayFieldStart(name);
                List listData = (List)entry.getValue();
                for (List vectorList : listData) {
                    gen.writeStartArray();
                    Iterator iterator = vectorList.iterator();
                    while (iterator.hasNext()) {
                        float f = ((Float)iterator.next()).floatValue();
                        gen.writeNumber(f);
                    }
                    gen.writeEndArray();
                }
                gen.writeEndArray();
            }
            gen.writeEndObject();
        } else if (value instanceof BatchVectorDataPlain) {
            BatchVectorDataPlain plainData = (BatchVectorDataPlain)value;
            gen.writeStartArray();
            for (List listData : plainData) {
                gen.writeStartArray();
                Iterator iterator = listData.iterator();
                while (iterator.hasNext()) {
                    float f = ((Float)iterator.next()).floatValue();
                    gen.writeNumber(f);
                }
                gen.writeEndArray();
            }
            gen.writeEndArray();
        } else {
            throw new RuntimeException("Enountered unknown vector data type. Got: " + value.getClass().getSimpleName());
        }
    }
}

