/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.client.http.impl;

import io.metaloom.qdrant.client.http.AbstractQDrantClient;
import io.metaloom.qdrant.client.http.QDrantBinaryResponse;
import io.metaloom.qdrant.client.http.QDrantClientRequest;
import io.metaloom.qdrant.client.http.model.CollectionClusterInfoResponse;
import io.metaloom.qdrant.client.http.model.GenericBooleanStatusResponse;
import io.metaloom.qdrant.client.http.model.RestRequestModel;
import io.metaloom.qdrant.client.http.model.RestResponse;
import io.metaloom.qdrant.client.http.model.cluster.ClusterStatusResponse;
import io.metaloom.qdrant.client.http.model.cluster.CollectionUpdateClusterSetupRequest;
import io.metaloom.qdrant.client.http.model.collection.CollectionCreateIndexFieldRequest;
import io.metaloom.qdrant.client.http.model.collection.CollectionCreateRequest;
import io.metaloom.qdrant.client.http.model.collection.CollectionIndexFieldResponse;
import io.metaloom.qdrant.client.http.model.collection.CollectionListResponse;
import io.metaloom.qdrant.client.http.model.collection.CollectionResponse;
import io.metaloom.qdrant.client.http.model.collection.CollectionUpdateAliasesRequest;
import io.metaloom.qdrant.client.http.model.collection.CollectionUpdateRequest;
import io.metaloom.qdrant.client.http.model.point.PointCountRequest;
import io.metaloom.qdrant.client.http.model.point.PointCountResponse;
import io.metaloom.qdrant.client.http.model.point.PointDeletePayloadRequest;
import io.metaloom.qdrant.client.http.model.point.PointGetResponse;
import io.metaloom.qdrant.client.http.model.point.PointOverwritePayloadRequest;
import io.metaloom.qdrant.client.http.model.point.PointSetPayloadRequest;
import io.metaloom.qdrant.client.http.model.point.PointsClearPayloadRequest;
import io.metaloom.qdrant.client.http.model.point.PointsDeleteRequest;
import io.metaloom.qdrant.client.http.model.point.PointsGetRequest;
import io.metaloom.qdrant.client.http.model.point.PointsGetResponse;
import io.metaloom.qdrant.client.http.model.point.PointsRecommendBatchRequest;
import io.metaloom.qdrant.client.http.model.point.PointsRecommendBatchResponse;
import io.metaloom.qdrant.client.http.model.point.PointsRecommendRequest;
import io.metaloom.qdrant.client.http.model.point.PointsRecommendResponse;
import io.metaloom.qdrant.client.http.model.point.PointsScrollRequest;
import io.metaloom.qdrant.client.http.model.point.PointsScrollResponse;
import io.metaloom.qdrant.client.http.model.point.PointsSearchBatchRequest;
import io.metaloom.qdrant.client.http.model.point.PointsSearchBatchResponse;
import io.metaloom.qdrant.client.http.model.point.PointsSearchRequest;
import io.metaloom.qdrant.client.http.model.point.PointsSearchResponse;
import io.metaloom.qdrant.client.http.model.point.PointsUpsertRequest;
import io.metaloom.qdrant.client.http.model.point.UpdateResultResponse;
import io.metaloom.qdrant.client.http.model.service.LockOptionResponse;
import io.metaloom.qdrant.client.http.model.service.LockRequest;
import io.metaloom.qdrant.client.http.model.service.ServiceTelemetryResponse;
import io.metaloom.qdrant.client.http.model.snapshot.SnapshotCreateResponse;
import io.metaloom.qdrant.client.http.model.snapshot.SnapshotListResponse;
import io.metaloom.qdrant.client.http.model.snapshot.SnapshotRecoverRequest;
import io.metaloom.qdrant.client.http.model.snapshot.SnapshotResponse;
import java.time.Duration;
import java.util.Objects;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QDrantHttpClientImpl
extends AbstractQDrantClient {
    public static final Logger log = LoggerFactory.getLogger(QDrantHttpClientImpl.class);
    private OkHttpClient client;

    public static Builder builder() {
        return new Builder();
    }

    protected QDrantHttpClientImpl(String scheme, String hostname, int port, Duration connectTimeout, Duration readTimeout, Duration writeTimeout) {
        super(scheme, hostname, port, connectTimeout, readTimeout, writeTimeout);
    }

    public void init() {
        this.client = this.createClient();
    }

    private OkHttpClient createClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(this.connectTimeout);
        builder.readTimeout(this.readTimeout);
        builder.writeTimeout(this.writeTimeout);
        return builder.build();
    }

    public OkHttpClient getOkHttpClient() {
        return this.client;
    }

    @Override
    public void close() {
    }

    @Override
    public QDrantClientRequest<PointGetResponse> getPoint(String collectionName, String pointId) {
        this.assertCollectionName(collectionName);
        return this.getRequest("collections/" + collectionName + "/points/" + pointId, PointGetResponse.class);
    }

    @Override
    public QDrantClientRequest<PointsGetResponse> getPoints(String collectionName, PointsGetRequest request) {
        this.assertCollectionName(collectionName);
        return this.postRequest("collections/" + collectionName + "/points", request, PointsGetResponse.class);
    }

    @Override
    public QDrantClientRequest<UpdateResultResponse> upsertPoints(String collectionName, PointsUpsertRequest request, boolean wait) {
        this.assertCollectionName(collectionName);
        QDrantClientRequest<UpdateResultResponse> req = this.putRequest("collections/" + collectionName + "/points", request, UpdateResultResponse.class);
        return req.addWait(wait);
    }

    @Override
    public QDrantClientRequest<UpdateResultResponse> deletePoints(String collectionName, PointsDeleteRequest request, boolean wait) {
        this.assertCollectionName(collectionName);
        QDrantClientRequest<UpdateResultResponse> req = this.postRequest("collections/" + collectionName + "/points/delete", request, UpdateResultResponse.class);
        return req.addWait(wait);
    }

    @Override
    public QDrantClientRequest<UpdateResultResponse> setPointPayload(String collectionName, PointSetPayloadRequest request, boolean wait) {
        this.assertCollectionName(collectionName);
        QDrantClientRequest<UpdateResultResponse> req = this.postRequest("collections/" + collectionName + "/points/payload", request, UpdateResultResponse.class);
        return req.addWait(wait);
    }

    @Override
    public QDrantClientRequest<UpdateResultResponse> overwritePayload(String collectionName, PointOverwritePayloadRequest request, boolean wait) {
        this.assertCollectionName(collectionName);
        QDrantClientRequest<UpdateResultResponse> req = this.putRequest("collections/" + collectionName + "/points/payload", request, UpdateResultResponse.class);
        return req.addWait(wait);
    }

    @Override
    public QDrantClientRequest<UpdateResultResponse> deletePayload(String collectionName, PointDeletePayloadRequest request, boolean wait) {
        this.assertCollectionName(collectionName);
        Objects.requireNonNull(request.getKeys(), "Keys must be specified");
        return this.postRequest("collections/" + collectionName + "/points/payload/delete", request, UpdateResultResponse.class);
    }

    @Override
    public QDrantClientRequest<UpdateResultResponse> clearPayload(String collectionName, PointsClearPayloadRequest request, boolean wait) {
        this.assertCollectionName(collectionName);
        QDrantClientRequest<UpdateResultResponse> req = this.postRequest("collections/" + collectionName + "/points/payload/clear", request, UpdateResultResponse.class);
        return req.addWait(wait);
    }

    @Override
    public QDrantClientRequest<PointsScrollResponse> scrollPoints(String collectionName, PointsScrollRequest request) {
        this.assertCollectionName(collectionName);
        return this.postRequest("collections/" + collectionName + "/points/scroll", request, PointsScrollResponse.class);
    }

    @Override
    public QDrantClientRequest<PointsSearchResponse> searchPoints(String collectionName, PointsSearchRequest request) {
        this.assertCollectionName(collectionName);
        Objects.requireNonNull(request.getVector(), "A vector must be specified to run the search");
        Objects.requireNonNull(Integer.valueOf(request.getLimit()), "A limit must be specified");
        return this.postRequest("collections/" + collectionName + "/points/search", request, PointsSearchResponse.class);
    }

    @Override
    public QDrantClientRequest<PointsSearchBatchResponse> searchBatchPoints(String collectionName, PointsSearchBatchRequest request) {
        this.assertCollectionName(collectionName);
        return this.postRequest("collections/" + collectionName + "/points/search/batch", request, PointsSearchBatchResponse.class);
    }

    @Override
    public QDrantClientRequest<PointsRecommendResponse> recommendPoints(String collectionName, PointsRecommendRequest request) {
        this.assertCollectionName(collectionName);
        return this.postRequest("collections/" + collectionName + "/points/recommend", request, PointsRecommendResponse.class);
    }

    @Override
    public QDrantClientRequest<PointsRecommendBatchResponse> recommendBatchPoints(String collectionName, PointsRecommendBatchRequest request) {
        this.assertCollectionName(collectionName);
        return this.postRequest("collections/" + collectionName + "/points/recommend/batch", request, PointsRecommendBatchResponse.class);
    }

    @Override
    public QDrantClientRequest<PointCountResponse> countPoints(String collectionName, PointCountRequest request) {
        this.assertCollectionName(collectionName);
        return this.postRequest("collections/" + collectionName + "/points/count", request, PointCountResponse.class);
    }

    @Override
    public QDrantClientRequest<ClusterStatusResponse> getClusterStatusInfo() {
        return this.getRequest("cluster", ClusterStatusResponse.class);
    }

    @Override
    public QDrantClientRequest<GenericBooleanStatusResponse> removePeerFromCluster(String peerId, boolean force) {
        QDrantClientRequest<GenericBooleanStatusResponse> request = this.getRequest("cluster/peer/" + peerId, GenericBooleanStatusResponse.class);
        return request.addForce(force);
    }

    @Override
    public QDrantClientRequest<CollectionClusterInfoResponse> getCollectionClusterInfo(String collectionName) {
        this.assertCollectionName(collectionName);
        return this.getRequest("collections/" + collectionName + "/cluster", CollectionClusterInfoResponse.class);
    }

    @Override
    public QDrantClientRequest<GenericBooleanStatusResponse> updateCollectionClusterSetup(String collectionName, CollectionUpdateClusterSetupRequest request) {
        this.assertCollectionName(collectionName);
        return this.postRequest("collections/" + collectionName + "/cluster", request, GenericBooleanStatusResponse.class);
    }

    @Override
    public QDrantClientRequest<SnapshotListResponse> listCollectionSnapshots(String collectionName) {
        this.assertCollectionName(collectionName);
        return this.getRequest("collections/" + collectionName + "/snapshots", SnapshotListResponse.class);
    }

    @Override
    public QDrantClientRequest<GenericBooleanStatusResponse> recoverSnapshot(String collectionName, SnapshotRecoverRequest request) {
        this.assertCollectionName(collectionName);
        Objects.requireNonNull(request, "A recovery request must be provided");
        return this.putRequest("collections/" + collectionName + "/snapshots/recover", request, GenericBooleanStatusResponse.class);
    }

    @Override
    public QDrantClientRequest<SnapshotResponse> createCollectionSnapshot(String collectionName) {
        this.assertCollectionName(collectionName);
        return this.postRequest("collections/" + collectionName + "/snapshots", SnapshotResponse.class);
    }

    @Override
    public QDrantClientRequest<QDrantBinaryResponse> downloadCollectionSnapshot(String collectionName, String snapshotName) {
        this.assertCollectionName(collectionName);
        return this.getRequest("collections/" + collectionName + "/snapshots/" + snapshotName, QDrantBinaryResponse.class);
    }

    @Override
    public QDrantClientRequest<SnapshotListResponse> listStorageSnapshots() {
        return this.getRequest("snapshots", SnapshotListResponse.class);
    }

    @Override
    public QDrantClientRequest<SnapshotCreateResponse> createStorageSnapshot() {
        return this.postRequest("snapshots", SnapshotCreateResponse.class);
    }

    @Override
    public QDrantClientRequest<QDrantBinaryResponse> downloadStorageSnapshot(String snapshotName) {
        return this.getRequest("snapshots/" + snapshotName, QDrantBinaryResponse.class);
    }

    @Override
    public QDrantClientRequest<ServiceTelemetryResponse> collectTelemetry(boolean anonymize) {
        QDrantClientRequest<ServiceTelemetryResponse> req = this.getRequest("telemetry", ServiceTelemetryResponse.class);
        return req.addAnonymize(anonymize);
    }

    @Override
    public QDrantClientRequest<LockOptionResponse> setLockOptions(String errorMessage, boolean lockFlag) {
        LockRequest request = new LockRequest();
        request.setErrorMessage(errorMessage);
        request.setWrite(lockFlag);
        return this.postRequest("locks", request, LockOptionResponse.class);
    }

    @Override
    public QDrantClientRequest<LockOptionResponse> getLockOptions() {
        return this.getRequest("locks", LockOptionResponse.class);
    }

    @Override
    public QDrantClientRequest<CollectionListResponse> listCollections() {
        return this.getRequest("collections", CollectionListResponse.class);
    }

    @Override
    public QDrantClientRequest<CollectionResponse> loadCollection(String collectionName) {
        return this.getRequest("collections/" + collectionName, CollectionResponse.class);
    }

    @Override
    public QDrantClientRequest<GenericBooleanStatusResponse> createCollection(String collectionName, CollectionCreateRequest request) {
        return this.putRequest("collections/" + collectionName, request, GenericBooleanStatusResponse.class);
    }

    @Override
    public QDrantClientRequest<GenericBooleanStatusResponse> updateCollection(String collectionName, CollectionUpdateRequest request, int timeout) {
        QDrantClientRequest<GenericBooleanStatusResponse> req = this.patchRequest("collections/" + collectionName, request, GenericBooleanStatusResponse.class);
        return req.addTimeout(timeout);
    }

    @Override
    public QDrantClientRequest<GenericBooleanStatusResponse> deleteCollection(String collectionName, int timeout) {
        QDrantClientRequest<GenericBooleanStatusResponse> req = this.deleteRequest("collections/" + collectionName, GenericBooleanStatusResponse.class);
        return req.addTimeout(timeout);
    }

    @Override
    public QDrantClientRequest<GenericBooleanStatusResponse> updateCollectionAliases(String collectionName, CollectionUpdateAliasesRequest request, int timeout) {
        QDrantClientRequest<GenericBooleanStatusResponse> req = this.postRequest("collections/aliases", request, GenericBooleanStatusResponse.class);
        return req.addTimeout(timeout);
    }

    @Override
    public QDrantClientRequest<CollectionIndexFieldResponse> createCollectionIndexField(String collectionName, CollectionCreateIndexFieldRequest request, boolean wait) {
        QDrantClientRequest<CollectionIndexFieldResponse> req = this.putRequest("collections/" + collectionName + "/index", request, CollectionIndexFieldResponse.class);
        return req.addWait(wait);
    }

    @Override
    public QDrantClientRequest<CollectionIndexFieldResponse> deleteCollectionIndexField(String collectionName, String fieldName, boolean wait) {
        QDrantClientRequest<CollectionIndexFieldResponse> req = this.deleteRequest("collections/" + collectionName + "/index/" + fieldName, CollectionIndexFieldResponse.class);
        return req.addWait(wait);
    }

    private <T extends RestResponse> QDrantClientRequest<T> deleteRequest(String path, Class<T> responseClass) {
        return QDrantClientRequest.create("DELETE", path, this, this.client, responseClass);
    }

    private <T extends RestResponse> QDrantClientRequest<T> getRequest(String path, Class<T> responseClass) {
        return QDrantClientRequest.create("GET", path, this, this.client, responseClass);
    }

    private <T extends RestResponse> QDrantClientRequest<T> postRequest(String path, RestRequestModel request, Class<T> responseClass) {
        return QDrantClientRequest.create("POST", path, this, this.client, request, responseClass);
    }

    private <T extends RestResponse> QDrantClientRequest<T> postRequest(String path, Class<T> responseClass) {
        return QDrantClientRequest.create("POST", path, this, this.client, responseClass);
    }

    private <T extends RestResponse> QDrantClientRequest<T> putRequest(String path, RestRequestModel request, Class<T> responseClass) {
        return QDrantClientRequest.create("PUT", path, this, this.client, request, responseClass);
    }

    private <T extends RestResponse> QDrantClientRequest<T> patchRequest(String path, RestRequestModel request, Class<T> responseClass) {
        return QDrantClientRequest.create("PATCH", path, this, this.client, request, responseClass);
    }

    private void assertCollectionName(String collectionName) {
        Objects.requireNonNull(collectionName, "A collection name must be specified");
    }

    public static class Builder {
        private String scheme = "http";
        private String hostname = "localhost";
        private int port = 6333;
        private Duration connectTimeout = Duration.ofMillis(10000L);
        private Duration readTimeout = Duration.ofMillis(10000L);
        private Duration writeTimeout = Duration.ofMillis(10000L);

        public QDrantHttpClientImpl build() {
            Objects.requireNonNull(this.scheme, "A protocol scheme has to be specified.");
            Objects.requireNonNull(this.hostname, "A hostname has to be specified.");
            QDrantHttpClientImpl client = new QDrantHttpClientImpl(this.scheme, this.hostname, this.port, this.connectTimeout, this.readTimeout, this.writeTimeout);
            client.init();
            return client;
        }

        public Builder setScheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setReadTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setWriteTimeout(Duration writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }
    }
}

