/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.client.http.impl;

import io.metaloom.qdrant.client.http.model.ErrorResponse;
import io.metaloom.qdrant.client.json.Json;
import java.util.function.Function;

public class HttpErrorException
extends Exception {
    private static final long serialVersionUID = -1799524340729007029L;
    private int statusCode;
    private String body;

    public HttpErrorException(String message, int statusCode, String body) {
        super(message);
        this.statusCode = statusCode;
        this.body = body;
    }

    public HttpErrorException(String message, Exception e) {
        super(message, e);
    }

    public String getBody() {
        return this.body;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public ErrorResponse getError() {
        return Json.parse(this.body, ErrorResponse.class);
    }

    public <T> T getBodyObject(Function<String, T> parser) {
        return parser.apply(this.getBody());
    }

    @Override
    public String toString() {
        return this.getMessage() + " - status: " + this.statusCode + " body {" + this.body + "}";
    }
}

