/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.client.http;

import io.metaloom.qdrant.client.http.model.RestResponse;
import io.reactivex.rxjava3.core.Flowable;
import java.io.InputStream;
import java.util.Arrays;

public interface QDrantBinaryResponse
extends RestResponse,
AutoCloseable {
    public static final int FLOWABLE_BUFFER_SIZE = 8192;

    public InputStream getStream();

    default public Flowable<byte[]> getFlowable() {
        Flowable f = Flowable.defer(() -> {
            InputStream stream = this.getStream();
            return Flowable.generate(emitter -> {
                byte[] buffer = new byte[8192];
                int count = stream.read(buffer);
                if (count == -1) {
                    stream.close();
                    this.close();
                    emitter.onComplete();
                } else if (count < 8192) {
                    emitter.onNext((Object)Arrays.copyOf(buffer, count));
                } else {
                    emitter.onNext((Object)buffer);
                }
            });
        });
        return f.doFinally(() -> this.close());
    }

    public String getFilename();

    public String getContentType();

    @Override
    public void close();

    public boolean isSuccessful();

    public int code();
}

