/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.client.util;

import io.metaloom.qdrant.client.grpc.proto.JsonWithInt;
import io.metaloom.qdrant.client.grpc.proto.Points;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class ModelHelper {
    private ModelHelper() {
    }

    public static Points.Vector vector(float[] vector) {
        Points.Vector.Builder builder = Points.Vector.newBuilder();
        for (int i = 0; i < vector.length; ++i) {
            builder.addData(vector[i]);
        }
        return builder.build();
    }

    public static List<Float> vectorList(Float ... vectors) {
        ArrayList<Float> vectorList = new ArrayList<Float>(vectors.length);
        Float[] floatArray = vectors;
        int n = floatArray.length;
        for (int i = 0; i < n; ++i) {
            float f = floatArray[i].floatValue();
            vectorList.add(Float.valueOf(f));
        }
        return vectorList;
    }

    public static JsonWithInt.Value value(String text) {
        return JsonWithInt.Value.newBuilder().setStringValue(text).build();
    }

    public static Points.PointId pointId(long id) {
        return Points.PointId.newBuilder().setNum(id).build();
    }

    public static Points.PointId pointId(UUID uuid) {
        Objects.requireNonNull(uuid, "The provided uuid must not be null");
        return Points.PointId.newBuilder().setUuid(uuid.toString()).build();
    }

    public static Points.PointId pointId(String uuid) {
        Objects.requireNonNull(uuid, "The provided uuid must not be null");
        return Points.PointId.newBuilder().setUuid(UUID.fromString(uuid).toString()).build();
    }

    public static List<Points.PointId> pointIds(long ... ids) {
        ArrayList<Points.PointId> list = new ArrayList<Points.PointId>();
        for (long id : ids) {
            list.add(ModelHelper.pointId(id));
        }
        return list;
    }

    public static Points.PointStruct point(String uuid, float[] vectorData, Map<String, JsonWithInt.Value> payload) {
        return ModelHelper.point(ModelHelper.pointId(uuid), vectorData, payload);
    }

    public static Points.PointStruct point(UUID uuid, float[] vectorData, Map<String, JsonWithInt.Value> payload) {
        return ModelHelper.point(ModelHelper.pointId(uuid), vectorData, payload);
    }

    public static Points.PointStruct point(long id, float[] vectorData, Map<String, JsonWithInt.Value> payload) {
        return ModelHelper.point(ModelHelper.pointId(id), vectorData, payload);
    }

    public static Points.PointStruct point(Points.PointId id, float[] vectorData, Map<String, JsonWithInt.Value> payload) {
        Objects.requireNonNull(id, "A pointId must be provided.");
        Points.Vector vector = ModelHelper.vector(vectorData);
        Points.PointStruct.Builder builder = Points.PointStruct.newBuilder().setId(id).setVectors(Points.Vectors.newBuilder().setVector(vector));
        if (payload != null) {
            builder.putAllPayload(payload);
        }
        return builder.build();
    }

    public static Points.PointStruct namedPoint(Long id, String vectorName, float[] vectorData, Map<String, JsonWithInt.Value> payload) {
        return ModelHelper.namedPoint(ModelHelper.pointId(id), vectorName, vectorData, payload);
    }

    public static Points.PointStruct namedPoint(Points.PointId id, String vectorName, float[] vectorData, Map<String, JsonWithInt.Value> payload) {
        Objects.requireNonNull(id, "A pointId must be provided.");
        Points.NamedVectors vectors = ModelHelper.namedVector(vectorName, vectorData);
        Points.PointStruct.Builder builder = Points.PointStruct.newBuilder().setId(id).setVectors(Points.Vectors.newBuilder().setVectors(vectors));
        if (payload != null) {
            builder.putAllPayload(payload);
        }
        return builder.build();
    }

    public static Points.PointsSelector selectByIds(Long ... ids) {
        Points.PointsIdsList.Builder pointList = Points.PointsIdsList.newBuilder();
        for (Long id : ids) {
            pointList.addIds(ModelHelper.pointId(id));
        }
        return Points.PointsSelector.newBuilder().setPoints(pointList.build()).build();
    }

    public static Points.WithPayloadSelector withPayload() {
        return Points.WithPayloadSelector.newBuilder().setEnable(true).build();
    }

    public static Points.WithVectorsSelector withVector() {
        return Points.WithVectorsSelector.newBuilder().setEnable(true).build();
    }

    public static Points.PointVectors pointVector(long id, String name, float[] vector) {
        Points.Vectors vectors = Points.Vectors.newBuilder().setVectors(ModelHelper.namedVector(name, vector)).build();
        return Points.PointVectors.newBuilder().setId(ModelHelper.pointId(id)).setVectors(vectors).build();
    }

    public static Points.NamedVectors namedVector(String name, float[] vector) {
        return Points.NamedVectors.newBuilder().putVectors(name, ModelHelper.vector(vector)).build();
    }
}

