/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.client.grpc.method;

import io.metaloom.qdrant.client.ClientSettings;
import io.metaloom.qdrant.client.grpc.InternalGrpcUtil;
import io.metaloom.qdrant.client.grpc.method.GrpcClientRequest;
import io.metaloom.qdrant.client.grpc.proto.SnapshotsService;
import java.util.Objects;

public interface SnapshotMethods
extends ClientSettings {
    default public GrpcClientRequest<SnapshotsService.CreateSnapshotResponse> createSnapshot() {
        SnapshotsService.CreateFullSnapshotRequest request = SnapshotsService.CreateFullSnapshotRequest.newBuilder().build();
        return this.request(() -> InternalGrpcUtil.snapshotsStub(this).createFull(request), () -> InternalGrpcUtil.snapshotsAsyncStub(this).createFull(request));
    }

    default public GrpcClientRequest<SnapshotsService.ListSnapshotsResponse> listSnapshots() {
        SnapshotsService.ListFullSnapshotsRequest request = SnapshotsService.ListFullSnapshotsRequest.newBuilder().build();
        return this.request(() -> InternalGrpcUtil.snapshotsStub(this).listFull(request), () -> InternalGrpcUtil.snapshotsAsyncStub(this).listFull(request));
    }

    default public GrpcClientRequest<SnapshotsService.DeleteSnapshotResponse> deleteSnapshot(String snapshotName) {
        Objects.requireNonNull(snapshotName, "A valid snapshot name must be provided");
        SnapshotsService.DeleteFullSnapshotRequest request = SnapshotsService.DeleteFullSnapshotRequest.newBuilder().setSnapshotName(snapshotName).build();
        return this.request(() -> InternalGrpcUtil.snapshotsStub(this).deleteFull(request), () -> InternalGrpcUtil.snapshotsAsyncStub(this).deleteFull(request));
    }

    default public GrpcClientRequest<SnapshotsService.CreateSnapshotResponse> createSnapshot(String collectionName) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        SnapshotsService.CreateSnapshotRequest request = SnapshotsService.CreateSnapshotRequest.newBuilder().setCollectionName(collectionName).build();
        return this.request(() -> InternalGrpcUtil.snapshotsStub(this).create(request), () -> InternalGrpcUtil.snapshotsAsyncStub(this).create(request));
    }

    default public GrpcClientRequest<SnapshotsService.ListSnapshotsResponse> listSnapshots(String collectionName) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        SnapshotsService.ListSnapshotsRequest request = SnapshotsService.ListSnapshotsRequest.newBuilder().setCollectionName(collectionName).build();
        return this.request(() -> InternalGrpcUtil.snapshotsStub(this).list(request), () -> InternalGrpcUtil.snapshotsAsyncStub(this).list(request));
    }

    default public GrpcClientRequest<SnapshotsService.DeleteSnapshotResponse> deleteCollectionSnapshot(String collectionName, String snapshotName) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        Objects.requireNonNull(snapshotName, "A valid snapshot name must be provided");
        SnapshotsService.DeleteSnapshotRequest request = SnapshotsService.DeleteSnapshotRequest.newBuilder().setCollectionName(collectionName).setSnapshotName(snapshotName).build();
        return this.request(() -> InternalGrpcUtil.snapshotsStub(this).delete(request), () -> InternalGrpcUtil.snapshotsAsyncStub(this).delete(request));
    }
}

