/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.client.grpc.method;

import io.metaloom.qdrant.client.ClientSettings;
import io.metaloom.qdrant.client.grpc.InternalGrpcUtil;
import io.metaloom.qdrant.client.grpc.method.GrpcClientRequest;
import io.metaloom.qdrant.client.grpc.proto.JsonWithInt;
import io.metaloom.qdrant.client.grpc.proto.Points;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public interface PointMethods
extends ClientSettings {
    default public GrpcClientRequest<Points.GetResponse> getPoint(String collectionName, Points.PointId pointId) {
        return this.getPoint(collectionName, null, null, pointId);
    }

    default public GrpcClientRequest<Points.GetResponse> getPoint(String collectionName, boolean withPayload, boolean withVector, Points.PointId pointId) {
        Points.WithPayloadSelector withPayloadSelector = Points.WithPayloadSelector.newBuilder().setEnable(withPayload).build();
        Points.WithVectorsSelector withVectorSelector = Points.WithVectorsSelector.newBuilder().setEnable(withVector).build();
        return this.getPoint(collectionName, withPayloadSelector, withVectorSelector, pointId);
    }

    default public GrpcClientRequest<Points.GetResponse> getPoint(String collectionName, Points.WithPayloadSelector withPayloadSelector, Points.WithVectorsSelector withVectorsSelector, Points.PointId pointId) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        Points.GetPoints.Builder request = Points.GetPoints.newBuilder().setCollectionName(collectionName).addIds(pointId);
        if (withPayloadSelector != null) {
            request.setWithPayload(withPayloadSelector);
        }
        if (withVectorsSelector != null) {
            request.setWithVectors(withVectorsSelector);
        }
        return this.request(() -> InternalGrpcUtil.pointsStub(this).get(request.build()), () -> InternalGrpcUtil.pointsAsyncStub(this).get(request.build()));
    }

    default public GrpcClientRequest<Points.GetResponse> getPoints(String collectionName, Points.WithPayloadSelector withPayloadSelector, Points.WithVectorsSelector withVectorsSelector, Points.PointId ... ids) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        return this.getPoints(collectionName, withPayloadSelector, withVectorsSelector, Arrays.asList(ids));
    }

    default public GrpcClientRequest<Points.GetResponse> getPoints(String collectionName, Points.WithPayloadSelector withPayloadSelector, Points.WithVectorsSelector withVectorsSelector, List<Points.PointId> ids) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        Objects.requireNonNull(ids, "Point Ids must be specified");
        Points.GetPoints.Builder request = Points.GetPoints.newBuilder().setCollectionName(collectionName).addAllIds(ids);
        if (withPayloadSelector != null) {
            request.setWithPayload(withPayloadSelector);
        }
        if (withVectorsSelector != null) {
            request.setWithVectors(withVectorsSelector);
        }
        return this.request(() -> InternalGrpcUtil.pointsStub(this).get(request.build()), () -> InternalGrpcUtil.pointsAsyncStub(this).get(request.build()));
    }

    default public GrpcClientRequest<Points.ScrollResponse> scrollPoint(String collectionName, Points.PointId offset, Integer limit, Points.Filter filter, Points.WithPayloadSelector withPayloadSelector, Points.WithVectorsSelector withVectorSelector) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        Points.ScrollPoints.Builder request = Points.ScrollPoints.newBuilder().setCollectionName(collectionName);
        if (offset != null) {
            request.setOffset(offset);
        }
        if (limit != null) {
            request.setLimit(limit);
        }
        if (withPayloadSelector != null) {
            request.setWithPayload(withPayloadSelector);
        }
        if (withVectorSelector != null) {
            request.setWithVectors(withVectorSelector);
        }
        if (filter != null) {
            request.setFilter(filter);
        }
        return this.request(() -> InternalGrpcUtil.pointsStub(this).scroll(request.build()), () -> InternalGrpcUtil.pointsAsyncStub(this).scroll(request.build()));
    }

    default public GrpcClientRequest<Points.CountResponse> countPoints(String collectionName, Points.Filter filter, boolean exact) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        Points.CountPoints.Builder request = Points.CountPoints.newBuilder().setCollectionName(collectionName).setExact(exact);
        if (filter != null) {
            request.setFilter(filter);
        }
        return this.request(() -> InternalGrpcUtil.pointsStub(this).count(request.build()), () -> InternalGrpcUtil.pointsAsyncStub(this).count(request.build()));
    }

    default public GrpcClientRequest<Points.PointsOperationResponse> clearPayload(String collectionName, boolean wait, Points.Filter filter, Points.PointId ... ids) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        Points.ClearPayloadPoints.Builder request = Points.ClearPayloadPoints.newBuilder().setCollectionName(collectionName).setWait(wait);
        Points.PointsSelector.Builder pointsSelector = Points.PointsSelector.newBuilder();
        if (filter != null) {
            pointsSelector.setFilter(filter);
        }
        if (ids.length > 0) {
            List<Points.PointId> points = Arrays.asList(ids);
            Points.PointsIdsList pointsList = Points.PointsIdsList.newBuilder().addAllIds(points).build();
            pointsSelector.setPoints(pointsList);
        }
        request.setPoints(pointsSelector.build());
        return this.request(() -> InternalGrpcUtil.pointsStub(this).clearPayload(request.build()), () -> InternalGrpcUtil.pointsAsyncStub(this).clearPayload(request.build()));
    }

    default public GrpcClientRequest<Points.PointsOperationResponse> deletePayload(String collectionName, boolean wait, Set<String> keys, Points.Filter filter, Points.PointId ... ids) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        Objects.requireNonNull(keys, "A set of keys has to be specified");
        Points.DeletePayloadPoints.Builder request = Points.DeletePayloadPoints.newBuilder().setCollectionName(collectionName).addAllKeys(keys).setWait(wait);
        boolean setSelector = false;
        Points.PointsSelector.Builder selector = Points.PointsSelector.newBuilder();
        if (filter != null) {
            selector.setFilter(filter);
            setSelector = true;
        }
        if (ids.length > 0) {
            selector.setPoints(Points.PointsIdsList.newBuilder().addAllIds(Arrays.asList(ids)).build());
            setSelector = true;
        }
        if (setSelector) {
            request.setPointsSelector(selector.build());
        }
        return this.request(() -> InternalGrpcUtil.pointsStub(this).deletePayload(request.build()), () -> InternalGrpcUtil.pointsAsyncStub(this).deletePayload(request.build()));
    }

    default public GrpcClientRequest<Points.PointsOperationResponse> overwritePayload(String collectionName, boolean wait, Points.Filter filter, Map<String, JsonWithInt.Value> payload, Points.PointId ... ids) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        Objects.requireNonNull(payload, "A payload must be specified");
        Points.PointsIdsList pointList = Points.PointsIdsList.newBuilder().addAllIds(Arrays.asList(ids)).build();
        Points.PointsSelector.Builder pointsSelectorBuilder = Points.PointsSelector.newBuilder().setPoints(pointList);
        if (filter != null) {
            pointsSelectorBuilder.setFilter(filter);
        }
        Points.PointsSelector pointsSelector = pointsSelectorBuilder.build();
        Points.SetPayloadPoints request = Points.SetPayloadPoints.newBuilder().setCollectionName(collectionName).setWait(wait).putAllPayload(payload).setPointsSelector(pointsSelector).build();
        return this.request(() -> InternalGrpcUtil.pointsStub(this).overwritePayload(request), () -> InternalGrpcUtil.pointsAsyncStub(this).overwritePayload(request));
    }

    default public GrpcClientRequest<Points.PointsOperationResponse> setPointPayload(String collectionName, boolean wait, Points.Filter filter, Map<String, JsonWithInt.Value> payload, Points.PointId ... ids) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        Objects.requireNonNull(payload, "A payload must be specified");
        Points.PointsIdsList pointList = Points.PointsIdsList.newBuilder().addAllIds(Arrays.asList(ids)).build();
        Points.PointsSelector.Builder pointsSelectorBuilder = Points.PointsSelector.newBuilder().setPoints(pointList);
        if (filter != null) {
            pointsSelectorBuilder.setFilter(filter);
        }
        Points.PointsSelector pointsSelector = pointsSelectorBuilder.build();
        Points.SetPayloadPoints request = Points.SetPayloadPoints.newBuilder().setCollectionName(collectionName).setWait(wait).putAllPayload(payload).setPointsSelector(pointsSelector).build();
        return this.request(() -> InternalGrpcUtil.pointsStub(this).setPayload(request), () -> InternalGrpcUtil.pointsAsyncStub(this).setPayload(request));
    }

    default public GrpcClientRequest<Points.PointsOperationResponse> deletePoints(String collectionName, boolean wait, Points.PointId ... ids) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        Points.PointsIdsList pointList = Points.PointsIdsList.newBuilder().addAllIds(Arrays.asList(ids)).build();
        Points.PointsSelector points = Points.PointsSelector.newBuilder().setPoints(pointList).build();
        Points.DeletePoints.Builder request = Points.DeletePoints.newBuilder().setCollectionName(collectionName).setPoints(points).setWait(wait);
        return this.request(() -> InternalGrpcUtil.pointsStub(this).delete(request.build()), () -> InternalGrpcUtil.pointsAsyncStub(this).delete(request.build()));
    }

    default public GrpcClientRequest<Points.PointsOperationResponse> upsertPoint(String collectionName, Points.PointStruct point, boolean wait) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        Objects.requireNonNull(point, "The batch of points has to be specified");
        return this.upsertPoints(collectionName, Arrays.asList(point), wait);
    }

    default public GrpcClientRequest<Points.PointsOperationResponse> upsertPoints(String collectionName, List<? extends Points.PointStruct> points, boolean wait) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        Objects.requireNonNull(points, "The batch of points has to be specified");
        Points.UpsertPoints.Builder request = Points.UpsertPoints.newBuilder().setCollectionName(collectionName).addAllPoints(points).setWait(wait);
        return this.request(() -> InternalGrpcUtil.pointsStub(this).upsert(request.build()), () -> InternalGrpcUtil.pointsAsyncStub(this).upsert(request.build()));
    }

    default public GrpcClientRequest<Points.PointsOperationResponse> updateVectors(Points.UpdatePointVectors request) {
        return this.request(() -> InternalGrpcUtil.pointsStub(this).updateVectors(request), () -> InternalGrpcUtil.pointsAsyncStub(this).updateVectors(request));
    }

    default public GrpcClientRequest<Points.PointsOperationResponse> deleteVectors(Points.DeletePointVectors request) {
        return this.request(() -> InternalGrpcUtil.pointsStub(this).deleteVectors(request), () -> InternalGrpcUtil.pointsAsyncStub(this).deleteVectors(request));
    }

    default public GrpcClientRequest<Points.SearchGroupsResponse> searchGroupPoints(Points.SearchPointGroups request) {
        return this.request(() -> InternalGrpcUtil.pointsStub(this).searchGroups(request), () -> InternalGrpcUtil.pointsAsyncStub(this).searchGroups(request));
    }

    default public GrpcClientRequest<Points.RecommendGroupsResponse> recommendGroupPoints(Points.RecommendPointGroups request) {
        return this.request(() -> InternalGrpcUtil.pointsStub(this).recommendGroups(request), () -> InternalGrpcUtil.pointsAsyncStub(this).recommendGroups(request));
    }
}

