/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.client.grpc.method;

import io.metaloom.qdrant.client.ClientSettings;
import io.metaloom.qdrant.client.grpc.InternalGrpcUtil;
import io.metaloom.qdrant.client.grpc.method.GrpcClientRequest;
import io.metaloom.qdrant.client.grpc.proto.Collections;
import java.util.Arrays;
import java.util.Objects;

public interface CollectionMethods
extends ClientSettings {
    default public GrpcClientRequest<Collections.ListCollectionsResponse> listCollections() {
        Collections.ListCollectionsRequest request = Collections.ListCollectionsRequest.newBuilder().build();
        return this.request(() -> InternalGrpcUtil.collectionsStub(this).list(request), () -> InternalGrpcUtil.collectionsAsyncStub(this).list(request));
    }

    default public GrpcClientRequest<Collections.GetCollectionInfoResponse> loadCollections(String collectionName) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        Collections.GetCollectionInfoRequest request = Collections.GetCollectionInfoRequest.newBuilder().setCollectionName(collectionName).build();
        return this.request(() -> InternalGrpcUtil.collectionsStub(this).get(request), () -> InternalGrpcUtil.collectionsAsyncStub(this).get(request));
    }

    default public GrpcClientRequest<Collections.CollectionOperationResponse> createCollection(String collectionName, Collections.VectorParams params) {
        Collections.VectorsConfig config = Collections.VectorsConfig.newBuilder().setParams(params).build();
        return this.createCollection(collectionName, config, null, null, null, null, null, null, null, null);
    }

    default public GrpcClientRequest<Collections.CollectionOperationResponse> createCollection(String collectionName, Collections.VectorParamsMap paramsMap) {
        Collections.VectorsConfig config = Collections.VectorsConfig.newBuilder().setParamsMap(paramsMap).build();
        return this.createCollection(collectionName, config, null, null, null, null, null, null, null, null);
    }

    default public GrpcClientRequest<Collections.CollectionOperationResponse> createCollection(String collectionName, Collections.VectorsConfig config, Integer shardNumber, Integer replicationFactor, Integer writeConsistencyFactor, Boolean onDiskPayload, Collections.HnswConfigDiff hnswConfig, Collections.WalConfigDiff walConfig, Collections.OptimizersConfigDiff optimizersConfig, Integer timeout) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        Collections.CreateCollection.Builder request = Collections.CreateCollection.newBuilder().setCollectionName(collectionName).setVectorsConfig(config);
        if (shardNumber != null) {
            request.setShardNumber(shardNumber);
        }
        if (replicationFactor != null) {
            request.setReplicationFactor(replicationFactor);
        }
        if (writeConsistencyFactor != null) {
            request.setWriteConsistencyFactor(writeConsistencyFactor);
        }
        if (onDiskPayload != null) {
            request.setOnDiskPayload(onDiskPayload);
        }
        if (hnswConfig != null) {
            request.setHnswConfig(hnswConfig);
        }
        if (walConfig != null) {
            request.setWalConfig(walConfig);
        }
        if (optimizersConfig != null) {
            request.setOptimizersConfig(optimizersConfig);
        }
        return this.request(() -> InternalGrpcUtil.collectionsStub(this).create(request.build()), () -> InternalGrpcUtil.collectionsAsyncStub(this).create(request.build()));
    }

    default public GrpcClientRequest<Collections.CollectionOperationResponse> deleteCollection(String collectionName, Integer timeout) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        Collections.DeleteCollection.Builder request = Collections.DeleteCollection.newBuilder().setCollectionName(collectionName);
        if (timeout != null) {
            request.setTimeout(timeout.intValue());
        }
        return this.request(() -> InternalGrpcUtil.collectionsStub(this).delete(request.build()), () -> InternalGrpcUtil.collectionsAsyncStub(this).delete(request.build()));
    }

    default public GrpcClientRequest<Collections.CollectionOperationResponse> updateCollectionAliases(Integer timeout, Collections.AliasOperations ... actions) {
        Objects.requireNonNull(actions, "Actions for the update operation must be specified.");
        Collections.ChangeAliases.Builder request = Collections.ChangeAliases.newBuilder().addAllActions(Arrays.asList(actions));
        if (timeout != null) {
            request.setTimeout(timeout.intValue());
        }
        return this.request(() -> InternalGrpcUtil.collectionsStub(this).updateAliases(request.build()), () -> InternalGrpcUtil.collectionsAsyncStub(this).updateAliases(request.build()));
    }

    default public GrpcClientRequest<Collections.ListAliasesResponse> listCollectionAliases(String collectionName) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        Collections.ListCollectionAliasesRequest.Builder request = Collections.ListCollectionAliasesRequest.newBuilder().setCollectionName(collectionName);
        return this.request(() -> InternalGrpcUtil.collectionsStub(this).listCollectionAliases(request.build()), () -> InternalGrpcUtil.collectionsAsyncStub(this).listCollectionAliases(request.build()));
    }

    default public GrpcClientRequest<Collections.CollectionOperationResponse> updateCollection(String collectionName, Collections.CollectionParamsDiff paramConfig) {
        return this.updateCollection(collectionName, paramConfig, null, null);
    }

    default public GrpcClientRequest<Collections.CollectionOperationResponse> updateCollection(String collectionName, Collections.CollectionParamsDiff paramConfig, Collections.OptimizersConfigDiff optimizerConfig, Integer timeout) {
        InternalGrpcUtil.assertCollectionName(collectionName);
        Collections.UpdateCollection.Builder request = Collections.UpdateCollection.newBuilder().setCollectionName(collectionName);
        if (optimizerConfig != null) {
            request.setOptimizersConfig(optimizerConfig);
        }
        if (paramConfig != null) {
            request.setParams(paramConfig);
        }
        if (timeout != null) {
            request.setTimeout(timeout.intValue());
        }
        return this.request(() -> InternalGrpcUtil.collectionsStub(this).update(request.build()), () -> InternalGrpcUtil.collectionsAsyncStub(this).update(request.build()));
    }
}

