/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.client.util;

import io.metaloom.qdrant.client.grpc.proto.JsonWithInt;
import io.metaloom.qdrant.client.grpc.proto.Points;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class ModelHelper {
    private ModelHelper() {
    }

    public static Points.Vector vector(float[] vector) {
        Points.Vector.Builder builder = Points.Vector.newBuilder();
        int i = 0;
        while (i < vector.length) {
            builder.addData(vector[i]);
            ++i;
        }
        return builder.build();
    }

    public static JsonWithInt.Value value(String text) {
        return JsonWithInt.Value.newBuilder().setStringValue(text).build();
    }

    public static Points.PointId pointId(long id) {
        return Points.PointId.newBuilder().setNum(id).build();
    }

    public static Points.PointId pointId(UUID uuid) {
        Objects.requireNonNull(uuid, "The provided uuid must not be null");
        return Points.PointId.newBuilder().setUuid(uuid.toString()).build();
    }

    public static Points.PointId pointId(String uuid) {
        Objects.requireNonNull(uuid, "The provided uuid must not be null");
        return Points.PointId.newBuilder().setUuid(UUID.fromString(uuid).toString()).build();
    }

    public static List<Points.PointId> pointIds(long ... ids) {
        ArrayList<Points.PointId> list = new ArrayList<Points.PointId>();
        long[] lArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            long id = lArray[n2];
            list.add(ModelHelper.pointId(id));
            ++n2;
        }
        return list;
    }

    public static Points.PointStruct point(String uuid, float[] vectorData, Map<String, JsonWithInt.Value> payload) {
        return ModelHelper.point(ModelHelper.pointId(uuid), vectorData, payload);
    }

    public static Points.PointStruct point(UUID uuid, float[] vectorData, Map<String, JsonWithInt.Value> payload) {
        return ModelHelper.point(ModelHelper.pointId(uuid), vectorData, payload);
    }

    public static Points.PointStruct point(long id, float[] vectorData, Map<String, JsonWithInt.Value> payload) {
        return ModelHelper.point(ModelHelper.pointId(id), vectorData, payload);
    }

    public static Points.PointStruct point(Points.PointId id, float[] vectorData, Map<String, JsonWithInt.Value> payload) {
        Objects.requireNonNull(id, "A pointId must be provided.");
        Points.Vector vector = ModelHelper.vector(vectorData);
        Points.PointStruct.Builder builder = Points.PointStruct.newBuilder().setId(id).setVectors(Points.Vectors.newBuilder().setVector(vector));
        if (payload != null) {
            builder.putAllPayload(payload);
        }
        return builder.build();
    }

    public static Points.WithPayloadSelector withPayload() {
        return Points.WithPayloadSelector.newBuilder().setEnable(true).build();
    }

    public static Points.WithVectorsSelector withVector() {
        return Points.WithVectorsSelector.newBuilder().setEnable(true).build();
    }
}

