/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.client.grpc.method;

import io.metaloom.qdrant.client.ClientSettings;
import io.metaloom.qdrant.client.grpc.InternalGrpcUtil;
import io.metaloom.qdrant.client.grpc.method.GrpcClientRequest;
import io.metaloom.qdrant.client.grpc.proto.Points;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public interface SearchMethods
extends ClientSettings {
    default public GrpcClientRequest<Points.SearchResponse> searchPoints(String collectionName, float[] vector, long limit, Float scoreThreshold) {
        return this.searchPoints(collectionName, vector, null, null, limit, null, null, null, scoreThreshold);
    }

    default public GrpcClientRequest<Points.SearchResponse> searchPoints(String collectionName, float[] vector, Points.Filter filter, Points.SearchParams params, long limit, Long offset, Points.WithPayloadSelector withPayloadSelector, Points.WithVectorsSelector withVectorsSelector, Float scoreThreshold) {
        Objects.requireNonNull(collectionName, "A collection name must be specified");
        ArrayList<Float> vectorList = new ArrayList<Float>(vector.length);
        float[] fArray = vector;
        int n = vector.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            vectorList.add(Float.valueOf(f));
            ++n2;
        }
        Points.SearchPoints.Builder request = Points.SearchPoints.newBuilder().setLimit(limit).addAllVector(vectorList).setCollectionName(collectionName);
        if (filter != null) {
            request.setFilter(filter);
        }
        if (params != null) {
            request.setParams(params);
        }
        if (offset != null) {
            request.setOffset(offset);
        }
        if (withPayloadSelector != null) {
            request.setWithPayload(withPayloadSelector);
        }
        if (withVectorsSelector != null) {
            request.setWithVectors(withVectorsSelector);
        }
        if (scoreThreshold != null) {
            request.setScoreThreshold(scoreThreshold.floatValue());
        }
        return this.request(() -> InternalGrpcUtil.pointsStub(this).search(request.build()), () -> InternalGrpcUtil.pointsAsyncStub(this).search(request.build()));
    }

    default public GrpcClientRequest<Points.SearchBatchResponse> searchBatch(String collectionName, List<? extends Points.SearchPoints> searches) {
        Objects.requireNonNull(collectionName, "A collection name must be specified");
        Objects.requireNonNull(searches, "A list of searches must be specified");
        Points.SearchBatchPoints.Builder request = Points.SearchBatchPoints.newBuilder().setCollectionName(collectionName).addAllSearchPoints(searches);
        return this.request(() -> InternalGrpcUtil.pointsStub(this).searchBatch(request.build()), () -> InternalGrpcUtil.pointsAsyncStub(this).searchBatch(request.build()));
    }

    default public GrpcClientRequest<Points.RecommendResponse> recommendPoints(String collectionName, List<Points.PointId> positives, int limit) {
        return this.recommendPoints(collectionName, positives, null, null, null, limit, null, null, null, null, null, null);
    }

    default public GrpcClientRequest<Points.RecommendResponse> recommendPoints(String collectionName, List<Points.PointId> positives, int limit, String using) {
        return this.recommendPoints(collectionName, positives, null, null, null, limit, null, null, null, null, using, null);
    }

    default public GrpcClientRequest<Points.RecommendResponse> recommendPoints(String collectionName, List<Points.PointId> positives, List<Points.PointId> negatives, Points.Filter filter, Points.SearchParams params, int limit, Integer offset, Points.WithPayloadSelector withPayload, Points.WithVectorsSelector withVector, Float scoreThreshold, String using, Points.LookupLocation lookupFrom) {
        Objects.requireNonNull(collectionName, "A collection name must be specified");
        Objects.requireNonNull(positives, "The start vector for the search has to be specified.");
        Points.RecommendPoints.Builder request = Points.RecommendPoints.newBuilder().setCollectionName(collectionName).addAllPositive(positives).setLimit(limit);
        if (negatives != null) {
            request.addAllNegative(negatives);
        }
        if (filter != null) {
            request.setFilter(filter);
        }
        if (params != null) {
            request.setParams(params);
        }
        if (offset != null) {
            request.setOffset(offset.intValue());
        }
        if (withPayload != null) {
            request.setWithPayload(withPayload);
        }
        if (withVector != null) {
            request.setWithVectors(withVector);
        }
        if (scoreThreshold != null) {
            request.setScoreThreshold(scoreThreshold.floatValue());
        }
        if (using != null) {
            request.setUsing(using);
        }
        if (lookupFrom != null) {
            request.setLookupFrom(lookupFrom);
        }
        return this.request(() -> InternalGrpcUtil.pointsStub(this).recommend(request.build()), () -> InternalGrpcUtil.pointsAsyncStub(this).recommend(request.build()));
    }

    default public GrpcClientRequest<Points.RecommendBatchResponse> recommendBatchPoints(String collectionName, List<? extends Points.RecommendPoints> searches) {
        Objects.requireNonNull(collectionName, "A collection name must be specified");
        Objects.requireNonNull(searches, "The list of searches must be specified");
        Points.RecommendBatchPoints request = Points.RecommendBatchPoints.newBuilder().setCollectionName(collectionName).addAllRecommendPoints(searches).build();
        return this.request(() -> InternalGrpcUtil.pointsStub(this).recommendBatch(request), () -> InternalGrpcUtil.pointsAsyncStub(this).recommendBatch(request));
    }
}

