/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.client.grpc.method;

import com.google.common.util.concurrent.ListenableFuture;
import io.metaloom.qdrant.client.ClientSettings;
import io.metaloom.qdrant.client.util.QDrantClientUtil;
import io.reactivex.rxjava3.core.Maybe;
import java.util.function.Supplier;

public class GrpcClientRequest<T> {
    private final Supplier<T> blocking;
    private final Supplier<ListenableFuture<T>> async;
    private final ClientSettings settings;

    public GrpcClientRequest(ClientSettings settings, Supplier<T> blockingSupplier, Supplier<ListenableFuture<T>> asyncSupplier) {
        this.settings = settings;
        this.blocking = blockingSupplier;
        this.async = asyncSupplier;
    }

    public T sync() {
        return this.blocking.get();
    }

    public ListenableFuture<T> async() {
        return this.async.get();
    }

    public Maybe<T> rx() {
        return QDrantClientUtil.toMaybe(this.async(), this.settings);
    }
}

