/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.client.grpc.impl;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.metaloom.qdrant.client.grpc.AbstractQDrantGRPCClient;
import java.time.Duration;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QDrantGRPCClientImpl
extends AbstractQDrantGRPCClient {
    public static final Logger log = LoggerFactory.getLogger(QDrantGRPCClientImpl.class);
    private ManagedChannel channel;

    protected QDrantGRPCClientImpl(String hostname, int port, Duration connectTimeout, Duration readTimeout, Duration writeTimeout) {
        super(hostname, port, connectTimeout, readTimeout, writeTimeout);
    }

    public static Builder builder() {
        return new Builder();
    }

    public QDrantGRPCClientImpl init() {
        this.channel = ManagedChannelBuilder.forAddress((String)this.hostname, (int)this.port).usePlaintext().build();
        return this;
    }

    @Override
    public void close() {
        if (this.channel != null) {
            this.channel.shutdown();
        } else {
            log.warn("gRPC channel has not been initialized.");
        }
    }

    @Override
    public ManagedChannel channel() {
        return this.channel;
    }

    public static class Builder {
        private String hostname = "localhost";
        private int port = 6334;
        private Duration connectTimeout = Duration.ofMillis(10000L);
        private Duration readTimeout = Duration.ofMillis(10000L);
        private Duration writeTimeout = Duration.ofMillis(10000L);

        public QDrantGRPCClientImpl build() {
            Objects.requireNonNull(this.hostname, "A hostname has to be specified.");
            QDrantGRPCClientImpl client = new QDrantGRPCClientImpl(this.hostname, this.port, this.connectTimeout, this.readTimeout, this.writeTimeout);
            client.init();
            return client;
        }

        public Builder setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setReadTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setWriteTimeout(Duration writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }
    }
}

