/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.client.util;

import java.util.ArrayList;
import java.util.List;

public final class VectorUtil {
    private VectorUtil() {
    }

    public static float[] toArray(List<Float> list) {
        float[] floatArray = new float[list.size()];
        int i = 0;
        for (Float f : list) {
            floatArray[i++] = f != null ? f.floatValue() : Float.NaN;
        }
        return floatArray;
    }

    public static double[] toDoubleArray(List<Float> list) {
        double[] doubleArray = new double[list.size()];
        int i = 0;
        for (Float f : list) {
            doubleArray[i++] = f != null ? (double)f.floatValue() : Double.NaN;
        }
        return doubleArray;
    }

    public static List<Float> toList(float ... values) {
        ArrayList<Float> result = new ArrayList<Float>(values.length);
        for (float id : values) {
            result.add(Float.valueOf(id));
        }
        return result;
    }

    public static List<Long> toList(long ... values) {
        ArrayList<Long> result = new ArrayList<Long>(values.length);
        for (long id : values) {
            result.add(id);
        }
        return result;
    }
}

