/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.qdrant.container;

import java.time.Duration;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class QDrantContainer
extends GenericContainer<QDrantContainer> {
    public static final String DEFAULT_VERSION = "v1.1.1";
    public static final int HTTP_PORT = 6333;
    public static final int GRPC_PORT = 6334;

    public QDrantContainer() {
        super("qdrant/qdrant:v1.1.1");
    }

    public QDrantContainer(String version) {
        super("qdrant/qdrant:" + version);
    }

    protected void configure() {
        this.withLogConsumer(c -> System.out.print(c.getUtf8String()));
        this.withExposedPorts(new Integer[]{6333, 6334});
        this.withStartupTimeout(Duration.ofSeconds(15L));
        this.waitingFor((WaitStrategy)Wait.forHttp((String)"/").forPort(6333));
    }

    public int grpcPort() {
        return this.getMappedPort(6334);
    }

    public int httpPort() {
        return this.getMappedPort(6333);
    }
}

