/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.maven.provider;

import io.metaloom.maven.provider.AbstractProviderMojo;
import io.metaloom.maven.provider.container.PostgreSQLPoolContainer;
import io.metaloom.test.container.provider.common.config.ProviderConfig;
import io.metaloom.test.container.provider.common.config.ProviderConfigHelper;
import io.metaloom.test.container.provider.container.DatabaseProviderContainer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="start", defaultPhase=LifecyclePhase.INITIALIZE)
public class ProviderStartMojo
extends AbstractProviderMojo {
    @Parameter(property="maven.testdb.reuse_containers", defaultValue="true")
    private boolean reuseContainers = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Start is skipped.");
            return;
        }
        ProviderConfig providerConfig = ProviderConfigHelper.readConfig();
        if (providerConfig != null) {
            this.getLog().warn((CharSequence)"Found config file. This means the provider is probably still running. You can stop containers via mvn testdatabase-provider:stop. Aborting start.");
            return;
        }
        PostgreSQLPoolContainer dbContainer = null;
        if (this.postgresqlMavenConfig != null) {
            if (this.postgresqlMavenConfig.isStartContainer()) {
                if (this.postgresqlMavenConfig.getPort() != null) {
                    this.getLog().warn((CharSequence)"Ignoring port setting. When starting a container the mapped port will be randomized.");
                }
                if (this.postgresqlMavenConfig.getHost() != null) {
                    this.getLog().warn((CharSequence)"Ignoring hostname setting. When starting a container the used host can't be selected.");
                }
                dbContainer = this.startPostgres(this.reuseContainers);
            } else {
                this.getLog().info((CharSequence)"Not starting postgreSQL container");
            }
        } else {
            this.getLog().info((CharSequence)"No postgreSQL settings found. Not starting database container.");
        }
        DatabaseProviderContainer providerContainer = null;
        if (this.providerMavenConfig != null && this.providerMavenConfig.isStartContainer()) {
            providerContainer = this.startProvider(this.reuseContainers, dbContainer);
        } else if (this.providerMavenConfig != null) {
            this.getLog().info((CharSequence)("Not starting testdatabase provider. Using " + this.providerMavenConfig.getHost() + ":" + this.providerMavenConfig.getPort() + " instead."));
            this.updateConfig(config -> {
                config.setProviderHost(this.providerMavenConfig.getHost());
                config.setProviderPort(this.providerMavenConfig.getPort().intValue());
            });
        } else {
            throw new MojoExecutionException("No provider config specified. Unable to execute goal without config.");
        }
        this.updateProviderConfig(providerContainer, dbContainer);
    }
}

