/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.test.container.provider.container;

import io.metaloom.test.container.provider.common.version.Version;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class DatabaseProviderContainer
extends GenericContainer<DatabaseProviderContainer> {
    public static final String DEFAULT_IMAGE = "metaloom/testdatabase-provider:" + Version.getPlainVersion();

    public DatabaseProviderContainer() {
        this(DEFAULT_IMAGE);
    }

    public DatabaseProviderContainer(String imageName) {
        super(DockerImageName.parse((String)imageName));
        this.withExposedPorts(new Integer[]{8080});
    }

    public int getPort() {
        return this.getFirstMappedPort();
    }

    public DatabaseProviderContainer withDefaultPoolDatabase(String host, int port, String internalHost, int internalPort, String username, String password, String database) {
        this.withEnv("TESTDATABASE_PROVIDER_DATABASE_HOST", host);
        this.withEnv("TESTDATABASE_PROVIDER_DATABASE_PORT", String.valueOf(port));
        this.withEnv("TESTDATABASE_PROVIDER_DATABASE_INTERNAL_HOST", internalHost);
        this.withEnv("TESTDATABASE_PROVIDER_DATABASE_INTERNAL_PORT", String.valueOf(internalPort));
        this.withEnv("TESTDATABASE_PROVIDER_DATABASE_USERNAME", username);
        this.withEnv("TESTDATABASE_PROVIDER_DATABASE_PASSWORD", password);
        this.withEnv("TESTDATABASE_PROVIDER_DATABASE_DBNAME_KEY", database);
        return this;
    }

    public DatabaseProviderContainer withDefaultMinimum(int minimumDatabases) {
        this.withEnv("TESTDATABASE_PROVIDER_POOL_MINIMUM", String.valueOf(minimumDatabases));
        return this;
    }

    public DatabaseProviderContainer withDefaultMaximum(int maximumDatabases) {
        this.withEnv("TESTDATABASE_PROVIDER_POOL_MAXIMUM", String.valueOf(maximumDatabases));
        return this;
    }

    public DatabaseProviderContainer withDefaultIncrement(int increment) {
        this.withEnv("TESTDATABASE_PROVIDER_POOL_INCREMENT", String.valueOf(increment));
        return this;
    }
}

