/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.maven.provider;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.StopContainerCmd;
import io.metaloom.maven.provider.AbstractProviderMojo;
import io.metaloom.test.container.provider.common.config.ProviderConfig;
import io.metaloom.test.container.provider.common.config.ProviderConfigHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.testcontainers.DockerClientFactory;

@Mojo(name="stop", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class ProviderStopMojo
extends AbstractProviderMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Stop is skipped.");
            return;
        }
        try {
            ProviderConfig config = ProviderConfigHelper.readConfig();
            if (config == null) {
                this.getLog().warn((CharSequence)("Unable to stop containers. Provider config file not found " + String.valueOf(ProviderConfigHelper.currentConfigPath())));
                return;
            }
            DockerClient client = DockerClientFactory.lazyClient();
            if (config.getProviderContainerId() != null) {
                this.stopProvider(client, config);
            }
            if (config.getPostgresql().getContainerId() != null) {
                this.stopDatabase(client, config);
            }
            ProviderConfigHelper.deleteConfig();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while stopping containers", e);
        }
    }

    private void stopDatabase(DockerClient client, ProviderConfig state) {
        try {
            this.getLog().info((CharSequence)"Stopping postgreSQL container");
            try (StopContainerCmd cmd = client.stopContainerCmd(state.getPostgresql().getContainerId());){
                cmd.exec();
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while stopping database ", (Throwable)e);
        }
    }

    private void stopProvider(DockerClient client, ProviderConfig state) {
        try {
            this.getLog().info((CharSequence)"Stopping database provider container");
            try (StopContainerCmd cmd = client.stopContainerCmd(state.getProviderContainerId());){
                cmd.exec();
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while stopping database provider", (Throwable)e);
        }
    }
}

