/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.maven.provider;

import org.apache.maven.plugins.annotations.Parameter;

public class PostgresqlMavenConfiguration {
    public static final String POSTGRESQL_CONFIG_PROP_KEY = "maven.testdb.postgresql";
    public static final String POSTGRESQL_DB_PROP_KEY = "maven.testdb.postgresql.database";
    public static final String POSTGRESQL_USERNAME_PROP_KEY = "maven.testdb.postgresql.username";
    public static final String POSTGRESQL_PASSWORD_PROP_KEY = "maven.testdb.postgresql.password";
    public static final String POSTGRESQL_JDBCURL_PROP_KEY = "maven.testdb.postgresql.jdbcurl";
    public static final String POSTGRESQL_HOST_PROP_KEY = "maven.testdb.postgresql.host";
    public static final String POSTGRESQL_PORT_PROP_KEY = "maven.testdb.postgresql.port";
    public static final String POSTGRESQL_INTERNAL_HOST_PROP_KEY = "maven.testdb.postgresql.internal_host";
    public static final String POSTGRESQL_INTERNAL_PORT_PROP_KEY = "maven.testdb.postgresql.internal_port";
    public static final String POSTGRESQL_START_CONTAINER_PROP_KEY = "maven.testdb.postgresql.start_container";
    private static final String POSTGRESQL_CONTAINER_IMAGE_PROP_KEY = "maven.testdb.postgresql.container_image";
    private static final String POSTGRESQL_TMPFS_SIZE_PROP_KEY = "maven.testdb.postgresql.tmpfs_size_mb";
    @Parameter(property="maven.testdb.postgresql.start_container", required=false, defaultValue="true")
    private boolean startContainer = true;
    @Parameter(property="maven.testdb.postgresql.container_image", required=false, defaultValue="postgres:13.2")
    private String containerImage;
    @Parameter(property="maven.testdb.postgresql.host", required=false)
    private String host;
    @Parameter(property="maven.testdb.postgresql.port", required=false)
    private Integer port;
    @Parameter(property="maven.testdb.postgresql.internal_host", required=false)
    private String internalHost;
    @Parameter(property="maven.testdb.postgresql.internal_port", required=false)
    private Integer internalPort;
    @Parameter(property="maven.testdb.postgresql.username", required=false, defaultValue="sa")
    private String username;
    @Parameter(property="maven.testdb.postgresql.password", required=false, defaultValue="sa")
    private String password;
    @Parameter(property="maven.testdb.postgresql.database", required=false, defaultValue="postgres")
    private String database;
    @Parameter(property="maven.testdb.postgresql.tmpfs_size_mb", required=false, defaultValue="128")
    private int tmpfsSizeMB = 128;

    public boolean isStartContainer() {
        return this.startContainer;
    }

    public String getContainerImage() {
        return this.containerImage;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getInternalHost() {
        return this.internalHost;
    }

    public Integer getInternalPort() {
        return this.internalPort;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getTmpfsSizeMB() {
        return this.tmpfsSizeMB;
    }

    public String getDatabase() {
        return this.database;
    }

    public boolean hasConnectionSettings() {
        return this.host != null && this.port != null && this.username != null && this.password != null && this.database != null;
    }

    public String getJdbcUrl() {
        return "jdbc:postgresql://" + this.getHost() + ":" + this.getPort() + "/" + this.getDatabase();
    }
}

