/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.maven.provider;

import io.metaloom.maven.provider.PoolLimits;
import io.metaloom.maven.provider.PostgresqlMavenConfiguration;
import io.metaloom.maven.provider.ProviderMavenConfiguration;
import io.metaloom.maven.provider.container.PostgreSQLPoolContainer;
import io.metaloom.test.container.provider.common.config.PostgresqlConfig;
import io.metaloom.test.container.provider.common.config.ProviderConfig;
import io.metaloom.test.container.provider.common.config.ProviderConfigHelper;
import io.metaloom.test.container.provider.container.DatabaseProviderContainer;
import java.util.function.Consumer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;

public abstract class AbstractProviderMojo
extends AbstractMojo {
    public static final String PROVIDER_SKIP_PROP_KEY = "maven.testdb.skip";
    public static final String PROVIDER_POOLS_PROPS_KEY = "maven.testdb.pools";
    public static final String PROVIDER_REUSE_CONTAINERS_PROP_KEY = "maven.testdb.reuse_containers";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="maven.testdb.postgresql", alias="postgresql")
    protected PostgresqlMavenConfiguration postgresqlMavenConfig = new PostgresqlMavenConfiguration();
    @Parameter(property="maven.testdb.provider", alias="provider")
    protected ProviderMavenConfiguration providerMavenConfig = new ProviderMavenConfiguration();
    @Parameter(property="maven.testdb.skip", defaultValue="false")
    protected boolean skip;
    public static final String TEST_DATABASE_NETWORK_ALIAS = "testdb";

    public void setProjectProp(String key, Object value) {
        if (value != null) {
            this.project.getProperties().put(key, value);
        }
    }

    public PostgreSQLPoolContainer startPostgres(boolean reuseContainers) throws MojoExecutionException {
        Network.NetworkImpl network = Network.builder().build();
        this.getLog().info((CharSequence)("Starting postgreSQL container using network " + network.getId()));
        if (this.postgresqlMavenConfig.getPort() != null) {
            throw new MojoExecutionException("The port can't be configured when a container should be provided. The mapped port will be randomized and set to the maven.testdb.postgresql.port property.");
        }
        String imageName = this.postgresqlMavenConfig.getContainerImage();
        PostgreSQLPoolContainer db = null;
        db = imageName == null ? new PostgreSQLPoolContainer() : new PostgreSQLPoolContainer(imageName);
        if (this.postgresqlMavenConfig.getTmpfsSizeMB() != 0) {
            db.withTmpFs(this.postgresqlMavenConfig.getTmpfsSizeMB());
        }
        if (reuseContainers) {
            db.withReuse(true);
        }
        ((PostgreSQLPoolContainer)db.withNetwork((Network)network)).withNetworkAliases(new String[]{TEST_DATABASE_NETWORK_ALIAS});
        if (this.postgresqlMavenConfig.getPassword() != null) {
            db.withPassword(this.postgresqlMavenConfig.getPassword());
        }
        if (this.postgresqlMavenConfig.getUsername() != null) {
            db.withPassword(this.postgresqlMavenConfig.getUsername());
        }
        if (this.postgresqlMavenConfig.getDatabase() != null) {
            db.withDatabaseName(this.postgresqlMavenConfig.getDatabase());
        }
        db.start();
        PostgreSQLPoolContainer finDB = db;
        this.updateConfig(state -> {
            PostgresqlConfig postgresqlConfig = state.getPostgresql();
            postgresqlConfig.setInternalHost(TEST_DATABASE_NETWORK_ALIAS);
            postgresqlConfig.setInternalPort(PostgreSQLContainer.POSTGRESQL_PORT);
            postgresqlConfig.setHost(finDB.getHost());
            postgresqlConfig.setPort(Integer.valueOf(finDB.getPort()));
            postgresqlConfig.setUsername(finDB.getUsername());
            postgresqlConfig.setPassword(finDB.getPassword());
            postgresqlConfig.setDatabaseName(finDB.getDatabaseName());
            postgresqlConfig.setContainerId(finDB.getContainerId());
        });
        this.getLog().debug((CharSequence)("Container DB Name:" + db.getJdbcUrl()));
        this.setProjectProp("maven.testdb.postgresql.database", db.getDatabaseName());
        this.getLog().debug((CharSequence)("Container JDBCUrl:" + db.getJdbcUrl()));
        this.setProjectProp("maven.testdb.postgresql.jdbcurl", db.getJdbcUrl());
        this.getLog().debug((CharSequence)("Container Host:" + db.getHost()));
        this.setProjectProp("maven.testdb.postgresql.host", db.getJdbcUrl());
        this.getLog().debug((CharSequence)("Container Username:" + db.getUsername()));
        this.setProjectProp("maven.testdb.postgresql.username", db.getUsername());
        this.getLog().debug((CharSequence)("Container Password:" + db.getPassword()));
        this.setProjectProp("maven.testdb.postgresql.password", db.getPassword());
        this.getLog().debug((CharSequence)("Container Port:" + db.getPort()));
        this.setProjectProp("maven.testdb.postgresql.port", db.getPort());
        return db;
    }

    public DatabaseProviderContainer startProvider(boolean reuseContainers, PostgreSQLPoolContainer db) throws MojoExecutionException {
        Integer internalDatabasePort;
        String internalDatabaseHost;
        this.getLog().info((CharSequence)"Starting database provider container");
        String databaseHost = this.postgresqlMavenConfig == null ? null : this.postgresqlMavenConfig.getHost();
        Integer databasePort = this.postgresqlMavenConfig == null ? null : this.postgresqlMavenConfig.getPort();
        String string = internalDatabaseHost = this.postgresqlMavenConfig == null ? null : this.postgresqlMavenConfig.getInternalHost();
        if (internalDatabaseHost == null) {
            internalDatabaseHost = databaseHost;
        }
        Integer n = internalDatabasePort = this.postgresqlMavenConfig == null ? null : this.postgresqlMavenConfig.getInternalPort();
        if (internalDatabasePort == null) {
            this.getLog().debug((CharSequence)"Using regular database port for internal connections since no internal port has been specified.");
            internalDatabasePort = databasePort;
        }
        if (db != null && (databaseHost != null || databasePort != null)) {
            throw new MojoExecutionException("It is not valid to configure a database host/port in conjunction with starting a database container. The container will automatically set the port and host for the provider.");
        }
        if (db != null) {
            internalDatabaseHost = TEST_DATABASE_NETWORK_ALIAS;
            internalDatabasePort = PostgreSQLContainer.POSTGRESQL_PORT;
        }
        DatabaseProviderContainer providerContainer = null;
        String customImage = this.postgresqlMavenConfig.getContainerImage();
        providerContainer = customImage != null ? new DatabaseProviderContainer(customImage) : new DatabaseProviderContainer();
        if (reuseContainers) {
            providerContainer.withReuse(true);
        }
        if (this.providerMavenConfig.getLimits() != null) {
            PoolLimits defaultLimits = this.providerMavenConfig.getLimits();
            this.getLog().info((CharSequence)("Setting default maximum level " + defaultLimits.getMaximum()));
            providerContainer.withDefaultMaximum(defaultLimits.getMaximum());
            this.getLog().info((CharSequence)("Setting default minimum level " + defaultLimits.getMinimum()));
            providerContainer.withDefaultMinimum(defaultLimits.getMinimum());
            this.getLog().info((CharSequence)("Setting default level increment " + defaultLimits.getIncrement()));
            providerContainer.withDefaultIncrement(defaultLimits.getIncrement());
        }
        if (this.providerMavenConfig.isCreatePool()) {
            if (db == null && this.postgresqlMavenConfig == null) {
                throw new MojoExecutionException("Unable to setup default pool. Please either set postgresql settings or enable the startup of the postgreSQL container");
            }
            if (db == null && this.postgresqlMavenConfig != null && !this.postgresqlMavenConfig.hasConnectionSettings()) {
                throw new MojoExecutionException("Unable to setup default pool. Please either set all needed postgresql settings (host, port, username, password, db) or enable the startup of the postgreSQL container");
            }
            this.getLog().info((CharSequence)"Setting default pool connection settings. This will create and start a default pool during startup.");
            String username = this.postgresqlMavenConfig.getUsername() != null ? this.postgresqlMavenConfig.getUsername() : db.getUsername();
            String password = this.postgresqlMavenConfig.getPassword() != null ? this.postgresqlMavenConfig.getPassword() : db.getPassword();
            String database = this.postgresqlMavenConfig.getDatabase() != null ? this.postgresqlMavenConfig.getDatabase() : db.getDatabaseName();
            providerContainer.withDefaultPoolDatabase(databaseHost, databasePort, internalDatabaseHost, internalDatabasePort, username, password, database);
        }
        if (db != null) {
            providerContainer.withNetwork(db.getNetwork());
        }
        providerContainer.start();
        String intHost = internalDatabaseHost;
        Integer intPort = internalDatabasePort;
        DatabaseProviderContainer finProviderContainer = providerContainer;
        this.updateConfig(config -> {
            config.setProviderHost(finProviderContainer.getHost());
            config.setProviderPort(finProviderContainer.getPort());
            config.getPostgresql().setInternalHost(intHost);
            config.getPostgresql().setInternalPort(intPort);
            config.setProviderContainerId(finProviderContainer.getContainerId());
        });
        return providerContainer;
    }

    protected void updateProviderConfig(DatabaseProviderContainer providerContainer, PostgreSQLPoolContainer dbContainer) {
        this.updateConfig(config -> {
            PostgresqlConfig postgresqlConfig = config.getPostgresql();
            if (dbContainer != null) {
                postgresqlConfig.setInternalHost(TEST_DATABASE_NETWORK_ALIAS);
                postgresqlConfig.setInternalPort(PostgreSQLContainer.POSTGRESQL_PORT);
                postgresqlConfig.setContainerId(dbContainer.getContainerId());
            } else {
                postgresqlConfig.setHost(this.postgresqlMavenConfig.getHost());
                postgresqlConfig.setPort(this.postgresqlMavenConfig.getPort());
                postgresqlConfig.setInternalHost(this.postgresqlMavenConfig.getInternalHost());
                postgresqlConfig.setInternalPort(this.postgresqlMavenConfig.getInternalPort());
                postgresqlConfig.setUsername(this.postgresqlMavenConfig.getUsername());
                postgresqlConfig.setPassword(this.postgresqlMavenConfig.getPassword());
                postgresqlConfig.setDatabaseName(this.postgresqlMavenConfig.getDatabase());
            }
            this.setProjectProp("maven.testdb.postgresql.database", postgresqlConfig.getDatabaseName());
            this.setProjectProp("maven.testdb.postgresql.jdbcurl", postgresqlConfig.jdbcUrl(""));
            this.setProjectProp("maven.testdb.postgresql.host", postgresqlConfig.getHost());
            this.setProjectProp("maven.testdb.postgresql.port", postgresqlConfig.getPort());
            this.setProjectProp("maven.testdb.postgresql.username", postgresqlConfig.getUsername());
            this.setProjectProp("maven.testdb.postgresql.password", postgresqlConfig.getPassword());
            if (this.providerMavenConfig == null) {
                this.providerMavenConfig = new ProviderMavenConfiguration();
            }
            if (providerContainer != null) {
                config.setProviderHost(providerContainer.getHost());
                config.setProviderPort(providerContainer.getPort());
                config.setProviderContainerId(providerContainer.getContainerId());
                this.providerMavenConfig.setHost(config.getProviderHost());
                this.providerMavenConfig.setPort(config.getProviderPort());
            } else {
                config.setProviderHost(this.providerMavenConfig.getHost());
                config.setProviderPort(this.providerMavenConfig.getPort().intValue());
            }
        });
    }

    public void updateConfig(Consumer<ProviderConfig> updateHandler) {
        try {
            ProviderConfig oldConfig = ProviderConfigHelper.readConfig();
            if (oldConfig == null) {
                oldConfig = new ProviderConfig();
            }
            updateHandler.accept(oldConfig);
            ProviderConfigHelper.writeConfig((ProviderConfig)oldConfig);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while updating provider config file.", (Throwable)e);
        }
    }
}

