/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.maven.provider;

import io.metaloom.maven.provider.AbstractProviderMojo;
import io.metaloom.maven.provider.PoolLimits;
import io.metaloom.maven.provider.PostgresqlSettings;
import io.metaloom.maven.provider.container.PostgreSQLPoolContainer;
import io.metaloom.test.container.provider.common.config.PostgresqlConfig;
import io.metaloom.test.container.provider.common.config.ProviderConfig;
import io.metaloom.test.container.provider.common.config.ProviderConfigHelper;
import io.metaloom.test.container.provider.container.DatabaseProviderContainer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;

@Mojo(name="start", defaultPhase=LifecyclePhase.INITIALIZE)
public class ProviderStartMojo
extends AbstractProviderMojo {
    public static final String TEST_DATABASE_NETWORK_ALIAS = "testdb";
    @Parameter(property="maven.testdatabase-provider.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="maven.testdatabase-provider.postgresql")
    private PostgresqlSettings postgresql;
    @Parameter(property="maven.testdatabase-provider.defaultLimits")
    private PoolLimits defaultLimits = new PoolLimits();
    @Parameter(property="maven.testdatabase-provider.startProvider", defaultValue="true")
    private boolean startProvider = true;
    @Parameter(property="maven.testdatabase-provider.providerContainerImage")
    private String providerContainerImage = DatabaseProviderContainer.DEFAULT_IMAGE;
    @Parameter(property="maven.testdatabase-provider.createPool", defaultValue="false")
    private boolean createPool = false;
    @Parameter(property="maven.testdatabase-provider.reuseContainers", defaultValue="true")
    private boolean reuseContainers = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Start is skipped.");
            return;
        }
        ProviderConfig config = ProviderConfigHelper.readConfig();
        if (config != null) {
            this.getLog().warn((CharSequence)"Found config file. This means the provider is probably still running. You can stop containers via mvn testdatabase-provider:stop. Aborting start.");
            return;
        }
        PostgreSQLPoolContainer dbContainer = null;
        if (this.postgresql != null) {
            if (this.postgresql.isStartContainer()) {
                if (this.postgresql.getPort() != null) {
                    this.getLog().warn((CharSequence)"Ignoring port setting. When starting a container the mapped port will be randomized");
                }
                if (this.postgresql.getHost() != null) {
                    this.getLog().warn((CharSequence)"Ignoring hostname setting. When starting a container the used host can't be selected.");
                }
                dbContainer = this.startPostgreSQLContainer();
            } else {
                this.setProjectProp("maven.testdatabase-provider.postgresql.database", this.postgresql.getDatabase());
                this.setProjectProp("maven.testdatabase-provider.postgresql.jdbcurl", this.postgresql.getJdbcUrl());
                this.setProjectProp("maven.testdatabase-provider.postgresql.host", this.postgresql.getHost());
                this.setProjectProp("maven.testdatabase-provider.postgresql.username", this.postgresql.getUsername());
                this.setProjectProp("maven.testdatabase-provider.postgresql.password", this.postgresql.getPassword());
                this.setProjectProp("maven.testdatabase-provider.postgresql.port", this.postgresql.getPort());
            }
        } else {
            this.getLog().info((CharSequence)"No postgreSQL settings found. Not starting database container.");
        }
        if (this.startProvider) {
            this.startProvider(dbContainer);
        } else {
            this.getLog().info((CharSequence)"Not starting testdatabase provider");
        }
    }

    private void startProvider(PostgreSQLPoolContainer db) throws MojoExecutionException {
        Integer internalDatabasePort;
        String internalDatabaseHost;
        this.getLog().info((CharSequence)"Starting database provider container");
        String databaseHost = this.postgresql == null ? null : this.postgresql.getHost();
        Integer databasePort = this.postgresql == null ? null : this.postgresql.getPort();
        String string = internalDatabaseHost = this.postgresql == null ? null : this.postgresql.getInternalHost();
        if (internalDatabaseHost == null) {
            this.getLog().debug((CharSequence)"Using regular database host for internal connections since no internal host has been specified.");
            internalDatabaseHost = databaseHost;
        }
        Integer n = internalDatabasePort = this.postgresql == null ? null : this.postgresql.getInternalPort();
        if (internalDatabasePort == null) {
            this.getLog().debug((CharSequence)"Using regular database port for internal connections since no internal port has been specified.");
            internalDatabasePort = databasePort;
        }
        if (db != null && (databaseHost != null || databasePort != null)) {
            throw new MojoExecutionException("It is not valid to configure a database host/port in conjunction with starting a database container. The container will automatically set the port and host for the provider.");
        }
        if (db != null) {
            internalDatabaseHost = TEST_DATABASE_NETWORK_ALIAS;
            internalDatabasePort = PostgreSQLContainer.POSTGRESQL_PORT;
        }
        DatabaseProviderContainer provider = new DatabaseProviderContainer(this.providerContainerImage);
        if (this.reuseContainers) {
            provider.withReuse(true);
        }
        if (this.defaultLimits != null) {
            this.getLog().info((CharSequence)("Setting default maximum level " + this.defaultLimits.getMaximum()));
            provider.withDefaultMaximum(this.defaultLimits.getMaximum());
            this.getLog().info((CharSequence)("Setting default minimum level " + this.defaultLimits.getMinimum()));
            provider.withDefaultMinimum(this.defaultLimits.getMinimum());
            this.getLog().info((CharSequence)("Setting default level increment " + this.defaultLimits.getIncrement()));
            provider.withDefaultIncrement(this.defaultLimits.getIncrement());
        }
        if (this.createPool) {
            if (db == null && this.postgresql == null) {
                throw new MojoExecutionException("Unable to setup default pool. Please either set postgresql settings or enable the startup of the postgreSQL container");
            }
            if (db == null && this.postgresql != null && !this.postgresql.hasConnectionSettings()) {
                throw new MojoExecutionException("Unable to setup default pool. Please either set all needed postgresql settings (host, port, username, password, db) or enable the startup of the postgreSQL container");
            }
            this.getLog().info((CharSequence)"Setting default pool connection settings. This will create and start a default pool during startup.");
            String username = this.postgresql.getUsername() != null ? this.postgresql.getUsername() : db.getUsername();
            String password = this.postgresql.getPassword() != null ? this.postgresql.getPassword() : db.getPassword();
            String database = this.postgresql.getDatabase() != null ? this.postgresql.getDatabase() : db.getDatabaseName();
            provider.withDefaultPoolDatabase(databaseHost, databasePort, internalDatabaseHost, internalDatabasePort, username, password, database);
        }
        if (db != null) {
            provider.withNetwork(db.getNetwork());
        }
        provider.start();
        String intHost = internalDatabaseHost;
        Integer intPort = internalDatabasePort;
        this.updateConfig(state -> {
            state.setProviderHost(provider.getHost());
            state.setProviderPort(provider.getPort());
            state.getPostgresql().setInternalHost(intHost);
            state.getPostgresql().setInternalPort(intPort);
            state.setProviderContainerId(provider.getContainerId());
        });
    }

    private PostgreSQLPoolContainer startPostgreSQLContainer() throws MojoExecutionException {
        Network.NetworkImpl network = Network.builder().build();
        this.getLog().info((CharSequence)("Starting postgreSQL container using network " + network.getId()));
        if (this.postgresql.getPort() != null) {
            throw new MojoExecutionException("The port can't be configured when a container should be provided. The mapped port will be randomized and set to the maven.testdatabase-provider.postgresql.port property.");
        }
        PostgreSQLPoolContainer db = new PostgreSQLPoolContainer(this.postgresql.getContainerImage(), this.postgresql.getTmpfsSizeMB());
        if (this.reuseContainers) {
            db.withReuse(true);
        }
        ((PostgreSQLPoolContainer)db.withNetwork((Network)network)).withNetworkAliases(new String[]{TEST_DATABASE_NETWORK_ALIAS});
        if (this.postgresql.getPassword() != null) {
            db.withPassword(this.postgresql.getPassword());
        }
        if (this.postgresql.getUsername() != null) {
            db.withPassword(this.postgresql.getUsername());
        }
        if (this.postgresql.getDatabase() != null) {
            db.withDatabaseName(this.postgresql.getDatabase());
        }
        db.start();
        this.updateConfig(state -> {
            PostgresqlConfig postgresqlState = state.getPostgresql();
            postgresqlState.setInternalHost(TEST_DATABASE_NETWORK_ALIAS);
            postgresqlState.setInternalPort(PostgreSQLContainer.POSTGRESQL_PORT);
            postgresqlState.setHost(db.getHost());
            postgresqlState.setPort(Integer.valueOf(db.getPort()));
            postgresqlState.setUsername(db.getUsername());
            postgresqlState.setPassword(db.getPassword());
            postgresqlState.setDatabaseName(db.getDatabaseName());
            postgresqlState.setContainerId(db.getContainerId());
        });
        this.getLog().debug((CharSequence)("Container DB Name:" + db.getJdbcUrl()));
        this.setProjectProp("maven.testdatabase-provider.postgresql.database", db.getDatabaseName());
        this.getLog().debug((CharSequence)("Container JDBCUrl:" + db.getJdbcUrl()));
        this.setProjectProp("maven.testdatabase-provider.postgresql.jdbcurl", db.getJdbcUrl());
        this.getLog().debug((CharSequence)("Container Host:" + db.getHost()));
        this.setProjectProp("maven.testdatabase-provider.postgresql.host", db.getJdbcUrl());
        this.getLog().debug((CharSequence)("Container Username:" + db.getUsername()));
        this.setProjectProp("maven.testdatabase-provider.postgresql.username", db.getUsername());
        this.getLog().debug((CharSequence)("Container Password:" + db.getPassword()));
        this.setProjectProp("maven.testdatabase-provider.postgresql.password", db.getPassword());
        this.getLog().debug((CharSequence)("Container Port:" + db.getPort()));
        this.setProjectProp("maven.testdatabase-provider.postgresql.port", db.getPort());
        return db;
    }
}

