/*
 * Decompiled with CFR 0.152.
 */
package io.metaloom.maven.provider;

import io.metaloom.maven.provider.AbstractProviderMojo;
import io.metaloom.maven.provider.PoolConfiguration;
import io.metaloom.maven.provider.PoolLimits;
import io.metaloom.test.container.provider.client.JSON;
import io.metaloom.test.container.provider.client.ProviderClient;
import io.metaloom.test.container.provider.common.config.ProviderConfig;
import io.metaloom.test.container.provider.common.config.ProviderConfigHelper;
import io.metaloom.test.container.provider.model.DatabasePoolConnection;
import io.metaloom.test.container.provider.model.DatabasePoolRequest;
import io.metaloom.test.container.provider.model.DatabasePoolResponse;
import io.metaloom.test.container.provider.model.DatabasePoolSettings;
import io.metaloom.test.container.provider.model.RestModel;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="pool", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES)
public class ProviderPoolMojo
extends AbstractProviderMojo {
    @Parameter(property="maven.testdatabase-provider.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="maven.testdatabase-provider.pools")
    private List<PoolConfiguration> pools;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Pool is skipped.");
            return;
        }
        try {
            ProviderConfig config = ProviderConfigHelper.readConfig();
            if (config == null) {
                this.getLog().warn((CharSequence)("Unable to stop containers. Provider config file not found " + String.valueOf(ProviderConfigHelper.currentConfigPath())));
            } else {
                this.getLog().info((CharSequence)"Applying pool configuration");
                String host = config.getProviderHost();
                int port = config.getProviderPort();
                ProviderClient client = new ProviderClient(host, port);
                for (PoolConfiguration pool : this.pools) {
                    if (pool.getId() == null) {
                        throw new MojoExecutionException("Pool id is missing for " + String.valueOf(pool));
                    }
                    DatabasePoolSettings settings = new DatabasePoolSettings();
                    PoolLimits limits = pool.getLimits();
                    if (limits != null) {
                        this.getLog().info((CharSequence)("Using provided " + String.valueOf(limits)));
                        settings.setMaximum(Integer.valueOf(limits.getMaximum()));
                        settings.setMinimum(Integer.valueOf(limits.getMinimum()));
                        settings.setIncrement(Integer.valueOf(limits.getIncrement()));
                    }
                    DatabasePoolConnection connection = new DatabasePoolConnection();
                    connection.setHost(this.merge("host", pool.getHost(), config.getPostgresql().getHost()));
                    connection.setPort(this.merge("port", pool.getPort(), config.getPostgresql().getPort()));
                    connection.setUsername(this.merge("username", pool.getUsername(), config.getPostgresql().getUsername()));
                    connection.setPassword(this.merge("password", pool.getPassword(), config.getPostgresql().getPassword()));
                    connection.setDatabase(this.merge("database", pool.getDatabase(), config.getPostgresql().getDatabaseName()));
                    connection.setInternalHost(this.merge("internalHost", pool.getInternalHost(), config.getPostgresql().getInternalHost()));
                    connection.setInternalPort(this.merge("internalPort", pool.getInternalPort(), config.getPostgresql().getInternalPort()));
                    DatabasePoolRequest request = new DatabasePoolRequest();
                    if (pool.getTemplateName() == null) {
                        throw new MojoExecutionException("Database template name is missing in pool configuration for " + String.valueOf(pool));
                    }
                    request.setTemplateDatabaseName(pool.getTemplateName());
                    request.setSettings(settings);
                    request.setConnection(connection);
                    DatabasePoolResponse response = (DatabasePoolResponse)client.createPool(pool.getId(), request).get();
                    this.getLog().info((CharSequence)("Response:\n" + JSON.toString((RestModel)response)));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unexpected error while invoking pool setup.", e);
        }
    }

    private <T> T merge(String key, T poolValue, T stateValue) throws MojoExecutionException {
        if (poolValue != null) {
            return poolValue;
        }
        if (stateValue != null) {
            this.getLog().debug((CharSequence)("Using state value for " + key));
            return stateValue;
        }
        throw new MojoExecutionException("Pool setting for " + key + " is not present in pool configuration or global state file which was written by the start goal.");
    }
}

