package io.meiro.sdk.track

import androidx.navigation.NavController
import io.meiro.sdk.MeiroSdk

/**
 * Adds automatic tracking of screen views to the [NavController]. It uses either the route or the
 * label of the destination as the screen name. If none of them are available, it does not track
 * the screen view.
 */
fun NavController.autoTrackScreenViews() {
    addOnDestinationChangedListener { _, destination, _ ->
        val screenName = listOfNotNull(
            destination.route,
            destination.label?.toString(),
        ).firstOrNull()
        if (screenName != null) {
            MeiroSdk.trackScreenView(screenName)
        }
    }
}
