package io.meiro.sdk.offline;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class EventDao_Impl implements EventDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<DbEvent> __insertionAdapterOfDbEvent;

  private final SharedSQLiteStatement __preparedStmtOfDeleteOlderThan;

  private final SharedSQLiteStatement __preparedStmtOfDeleteById;

  public EventDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfDbEvent = new EntityInsertionAdapter<DbEvent>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `DbEvent` (`id`,`type`,`timestamp`,`version`,`propertiesSerialized`,`appInfoId`,`appInfoName`,`appInfoVersion`,`appInfoLanguage`,`appInfoAdId`,`osInfoType`,`osInfoVersion`,`deviceInfoManufacturer`,`deviceInfoModel`,`firebaseInfoProjectId`,`firebaseInfoToken`,`userInfoUserId`,`userInfoSessionId`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final DbEvent entity) {
        statement.bindLong(1, entity.getId());
        statement.bindString(2, entity.getType());
        statement.bindLong(3, entity.getTimestamp());
        statement.bindString(4, entity.getVersion());
        statement.bindString(5, entity.getPropertiesSerialized());
        if (entity.getAppInfoId() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getAppInfoId());
        }
        statement.bindString(7, entity.getAppInfoName());
        statement.bindString(8, entity.getAppInfoVersion());
        if (entity.getAppInfoLanguage() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getAppInfoLanguage());
        }
        if (entity.getAppInfoAdId() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getAppInfoAdId());
        }
        statement.bindString(11, entity.getOsInfoType());
        statement.bindString(12, entity.getOsInfoVersion());
        statement.bindString(13, entity.getDeviceInfoManufacturer());
        statement.bindString(14, entity.getDeviceInfoModel());
        if (entity.getFirebaseInfoProjectId() == null) {
          statement.bindNull(15);
        } else {
          statement.bindString(15, entity.getFirebaseInfoProjectId());
        }
        if (entity.getFirebaseInfoToken() == null) {
          statement.bindNull(16);
        } else {
          statement.bindString(16, entity.getFirebaseInfoToken());
        }
        statement.bindString(17, entity.getUserInfoUserId());
        statement.bindString(18, entity.getUserInfoSessionId());
      }
    };
    this.__preparedStmtOfDeleteOlderThan = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM DbEvent WHERE timestamp < ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteById = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM DbEvent where id = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insert(final DbEvent event, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfDbEvent.insert(event);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object deleteOlderThan(final long timestamp,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteOlderThan.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, timestamp);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteOlderThan.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object deleteById(final int id, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteById.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, id);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteById.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object getAll(final Continuation<? super List<DbEvent>> $completion) {
    final String _sql = "SELECT * FROM DbEvent";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<DbEvent>>() {
      @Override
      @NonNull
      public List<DbEvent> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
          final int _cursorIndexOfVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "version");
          final int _cursorIndexOfPropertiesSerialized = CursorUtil.getColumnIndexOrThrow(_cursor, "propertiesSerialized");
          final int _cursorIndexOfAppInfoId = CursorUtil.getColumnIndexOrThrow(_cursor, "appInfoId");
          final int _cursorIndexOfAppInfoName = CursorUtil.getColumnIndexOrThrow(_cursor, "appInfoName");
          final int _cursorIndexOfAppInfoVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "appInfoVersion");
          final int _cursorIndexOfAppInfoLanguage = CursorUtil.getColumnIndexOrThrow(_cursor, "appInfoLanguage");
          final int _cursorIndexOfAppInfoAdId = CursorUtil.getColumnIndexOrThrow(_cursor, "appInfoAdId");
          final int _cursorIndexOfOsInfoType = CursorUtil.getColumnIndexOrThrow(_cursor, "osInfoType");
          final int _cursorIndexOfOsInfoVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "osInfoVersion");
          final int _cursorIndexOfDeviceInfoManufacturer = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceInfoManufacturer");
          final int _cursorIndexOfDeviceInfoModel = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceInfoModel");
          final int _cursorIndexOfFirebaseInfoProjectId = CursorUtil.getColumnIndexOrThrow(_cursor, "firebaseInfoProjectId");
          final int _cursorIndexOfFirebaseInfoToken = CursorUtil.getColumnIndexOrThrow(_cursor, "firebaseInfoToken");
          final int _cursorIndexOfUserInfoUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userInfoUserId");
          final int _cursorIndexOfUserInfoSessionId = CursorUtil.getColumnIndexOrThrow(_cursor, "userInfoSessionId");
          final List<DbEvent> _result = new ArrayList<DbEvent>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final DbEvent _item;
            final int _tmpId;
            _tmpId = _cursor.getInt(_cursorIndexOfId);
            final String _tmpType;
            _tmpType = _cursor.getString(_cursorIndexOfType);
            final long _tmpTimestamp;
            _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
            final String _tmpVersion;
            _tmpVersion = _cursor.getString(_cursorIndexOfVersion);
            final String _tmpPropertiesSerialized;
            _tmpPropertiesSerialized = _cursor.getString(_cursorIndexOfPropertiesSerialized);
            final String _tmpAppInfoId;
            if (_cursor.isNull(_cursorIndexOfAppInfoId)) {
              _tmpAppInfoId = null;
            } else {
              _tmpAppInfoId = _cursor.getString(_cursorIndexOfAppInfoId);
            }
            final String _tmpAppInfoName;
            _tmpAppInfoName = _cursor.getString(_cursorIndexOfAppInfoName);
            final String _tmpAppInfoVersion;
            _tmpAppInfoVersion = _cursor.getString(_cursorIndexOfAppInfoVersion);
            final String _tmpAppInfoLanguage;
            if (_cursor.isNull(_cursorIndexOfAppInfoLanguage)) {
              _tmpAppInfoLanguage = null;
            } else {
              _tmpAppInfoLanguage = _cursor.getString(_cursorIndexOfAppInfoLanguage);
            }
            final String _tmpAppInfoAdId;
            if (_cursor.isNull(_cursorIndexOfAppInfoAdId)) {
              _tmpAppInfoAdId = null;
            } else {
              _tmpAppInfoAdId = _cursor.getString(_cursorIndexOfAppInfoAdId);
            }
            final String _tmpOsInfoType;
            _tmpOsInfoType = _cursor.getString(_cursorIndexOfOsInfoType);
            final String _tmpOsInfoVersion;
            _tmpOsInfoVersion = _cursor.getString(_cursorIndexOfOsInfoVersion);
            final String _tmpDeviceInfoManufacturer;
            _tmpDeviceInfoManufacturer = _cursor.getString(_cursorIndexOfDeviceInfoManufacturer);
            final String _tmpDeviceInfoModel;
            _tmpDeviceInfoModel = _cursor.getString(_cursorIndexOfDeviceInfoModel);
            final String _tmpFirebaseInfoProjectId;
            if (_cursor.isNull(_cursorIndexOfFirebaseInfoProjectId)) {
              _tmpFirebaseInfoProjectId = null;
            } else {
              _tmpFirebaseInfoProjectId = _cursor.getString(_cursorIndexOfFirebaseInfoProjectId);
            }
            final String _tmpFirebaseInfoToken;
            if (_cursor.isNull(_cursorIndexOfFirebaseInfoToken)) {
              _tmpFirebaseInfoToken = null;
            } else {
              _tmpFirebaseInfoToken = _cursor.getString(_cursorIndexOfFirebaseInfoToken);
            }
            final String _tmpUserInfoUserId;
            _tmpUserInfoUserId = _cursor.getString(_cursorIndexOfUserInfoUserId);
            final String _tmpUserInfoSessionId;
            _tmpUserInfoSessionId = _cursor.getString(_cursorIndexOfUserInfoSessionId);
            _item = new DbEvent(_tmpId,_tmpType,_tmpTimestamp,_tmpVersion,_tmpPropertiesSerialized,_tmpAppInfoId,_tmpAppInfoName,_tmpAppInfoVersion,_tmpAppInfoLanguage,_tmpAppInfoAdId,_tmpOsInfoType,_tmpOsInfoVersion,_tmpDeviceInfoManufacturer,_tmpDeviceInfoModel,_tmpFirebaseInfoProjectId,_tmpFirebaseInfoToken,_tmpUserInfoUserId,_tmpUserInfoSessionId);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
