package io.meiro.sdk.offline

import androidx.room.Entity
import androidx.room.PrimaryKey

@Entity
internal data class DbEvent(
    @PrimaryKey(autoGenerate = true) val id: Int,
    val type: String,
    val timestamp: Long,
    val version: String,
    val propertiesSerialized: String,
    val appInfoId: String?,
    val appInfoName: String,
    val appInfoVersion: String,
    val appInfoLanguage: String?,
    val appInfoAdId: String?,
    val osInfoType: String,
    val osInfoVersion: String,
    val deviceInfoManufacturer: String,
    val deviceInfoModel: String,
    val firebaseInfoProjectId: String?,
    val firebaseInfoToken: String?,
    val userInfoUserId: String,
    val userInfoSessionId: String
)
