package io.meiro.sdk.fcm

import com.google.firebase.messaging.FirebaseMessagingService
import com.google.firebase.messaging.RemoteMessage
import io.meiro.sdk.MeiroSdk

/**
 * Firebase Messaging Service for Meiro SDK. If the application using this library has their own
 * notifications handling, it should implement their own [FirebaseMessagingService] and delegate
 * displaying the Meiro messages to [MeiroNotifications] if it's a Meiro message.
 */
internal class MeiroFcmMessagingService : FirebaseMessagingService() {

    override fun onMessageReceived(message: RemoteMessage) {
        super.onMessageReceived(message)
        if (MeiroNotifications.isMeiroMessage(message)) {
            MeiroSdk.impl?.requireConfiguration()?.pushNotifications?.let { notificationsConfiguration ->
                MeiroNotifications.show(
                    context = this,
                    configuration = notificationsConfiguration,
                    message = message
                )
            }
        }
    }

    override fun onNewToken(token: String) {
        super.onNewToken(token)
        MeiroSdk.setFcmToken(token)
    }
}
