package io.meiro.sdk.api

import io.meiro.sdk.event.Event
import kotlinx.serialization.json.JsonElement
import kotlinx.serialization.json.JsonPrimitive

internal class ApiEventMapping {

    fun toApiEvent(event: Event): ApiEvent {
        return ApiEvent(
            userId = event.userInfo.userId,
            sessionId = event.userInfo.sessionId,
            eventType = event.type.id,
            eventTimestamp = event.timestamp.toString(),
            eventData = event.properties.mapValues {
                if (it.value is JsonElement) {
                    it.value as JsonElement
                } else {
                    JsonPrimitive(it.value.toString())
                }
            },
            app = ApiEventAppInfo(
                id = event.appInfo.id,
                name = event.appInfo.name,
                version = event.appInfo.version,
                language = event.appInfo.language,
                adId = event.appInfo.adId
            ),
            os = ApiEventOsInfo(
                type = event.osInfo.type,
                version = event.osInfo.version
            ),
            device = event.deviceInfo?.let { deviceInfo ->
                ApiEventDeviceInfo(
                    manufacturer = deviceInfo.manufacturer,
                    model = deviceInfo.model
                )
            },
            firebase = ApiEventFirebaseInfo(
                projectId = event.firebaseInfo.projectId,
                registrationToken = event.firebaseInfo.token
            ),
            version = event.version
        )
    }
}
