package io.meiro.sdk.api

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonElement

@Serializable
internal data class ApiEvent(
    @SerialName("user_id")
    val userId: String,
    @SerialName("session_id")
    val sessionId: String,
    @SerialName("event_type")
    val eventType: String,
    @SerialName("event_timestamp")
    val eventTimestamp: String,
    @SerialName("event_data")
    val eventData: Map<String, JsonElement>?,
    @SerialName("version")
    val version: String,
    @SerialName("app")
    val app: ApiEventAppInfo,
    @SerialName("os")
    val os: ApiEventOsInfo,
    @SerialName("device")
    val device: ApiEventDeviceInfo?,
    @SerialName("firebase")
    val firebase: ApiEventFirebaseInfo,
)

@Serializable
internal data class ApiEventAppInfo(
    @SerialName("id")
    val id: String?,
    @SerialName("name")
    val name: String,
    @SerialName("version")
    val version: String,
    @SerialName("language")
    val language: String?,
    @SerialName("ad_id")
    val adId: String?,
)

@Serializable
internal data class ApiEventOsInfo(
    @SerialName("type")
    val type: String,
    @SerialName("version")
    val version: String?,
)

@Serializable
internal data class ApiEventDeviceInfo(
    @SerialName("manufacturer")
    val manufacturer: String,
    @SerialName("model")
    val model: String,
)

@Serializable
internal data class ApiEventFirebaseInfo(
    @SerialName("project_id")
    val projectId: String?,
    @SerialName("registration_token")
    val registrationToken: String?,
)
