package io.meiro.sdk

import android.content.Context
import io.meiro.sdk.audience.MeiroAudience

/**
 * Interface for Meiro SDK events
 */
internal interface MeiroEvents {

    /**
     * User id of the current user
     */
    val userId: String

    /**
     * Current session id
     */
    val sessionId: String

    /**
     * Initialize the SDK
     *
     * @param context application context
     * @param configuration configuration of the SDK
     * @param logger logger for the SDK
     */
    fun init(
        context: Context,
        configuration: Configuration,
        logger: MeiroLogger = MeiroAndroidLogger()
    )

    /**
     * Enable or disable the SDK
     */
    fun setEnabled(enabled: Boolean)

    /**
     * Track a custom event
     */
    fun trackCustomEvent(properties: Map<String, Any>)

    /**
     * Reset the identity of the user
     */
    fun resetIdentity()

    /**
     * Track click on a [url]
     */
    fun trackLinkClick(url: String)

    /**
     * Track a screen view with [name] and optional [properties
     */
    fun trackScreenView(name: String, properties: Map<String, Any> = emptyMap())

    /**
     * Set the Firebase Cloud Messaging token
     */
    fun setFcmToken(token: String)

    /**
     * Access to [MeiroAudience] API
     */
    fun getAudience(): MeiroAudience
}
