package io.meiro.sdk

import io.meiro.sdk.fcm.PushNotificationsConfiguration

/**
 * Configuration of the SDK
 *
 * @property endpoint Meiro Data Platform endpoint
 * @property appId application id. If you are using Firebase, you should use `R.string.google_app_id`
 * @property debugMode if enabled, includes additional logs. Should be disabled in production
 * @property pushNotifications push notifications configuration
 * @property automaticTrackingEnabled if enabled, automatic tracking of events will be performed
 * @property language language of the application. Used if you want to target users by language
 * @property firebaseProjectId Firebase project id. If you are using Firebase, you should use `R.string.project_id`
 */
data class Configuration @JvmOverloads constructor(
    val endpoint: String,
    val appId: String,
    val debugMode: Boolean = false,
    val pushNotifications: PushNotificationsConfiguration = PushNotificationsConfiguration(),
    val automaticTrackingEnabled: Boolean = true,
    val language: String? = null,
    val firebaseProjectId: String? = null,
)
