package io.meiro.sdk.offline.workmanager

import android.content.Context
import androidx.work.BackoffPolicy
import androidx.work.Constraints
import androidx.work.CoroutineWorker
import androidx.work.NetworkType
import androidx.work.OneTimeWorkRequest
import androidx.work.WorkerParameters
import io.meiro.sdk.MeiroSdk
import java.util.concurrent.TimeUnit

/**
 * Worker for performing sync operation every time a device is connected to internet.
 */
internal class SyncWorker(context: Context, workerParams: WorkerParameters) : CoroutineWorker(context, workerParams) {

    override suspend fun doWork(): Result {
        return try {
            MeiroSdk.performSync()
            Result.success()
        } catch (e: Exception) {
            Result.retry()
        }
    }

    companion object {

        internal const val WORK_NAME = "io.meiro.sdk.offline.workmanager.SyncWorker"

        fun createWorkRequest(): OneTimeWorkRequest {
            return OneTimeWorkRequest.Builder(SyncWorker::class.java)
                .setConstraints(
                    Constraints.Builder()
                        .setRequiredNetworkType(NetworkType.CONNECTED)
                        .build()
                )
                .setBackoffCriteria(BackoffPolicy.EXPONENTIAL, backoffDelay = 5, timeUnit = TimeUnit.SECONDS)
                .build()
        }
    }
}
