package io.meiro.sdk.fcm

import androidx.annotation.DrawableRes

/**
 * Configuration for displaying push notifications
 *
 * @property pushEnabled Whether push notifications handling is enabled or not
 * @property accentColor Accent color of push notification icon and buttons. A color value, not resource id is expected here, e.g. context.resources.getColor(R.color.something)
 * @property channelName Channel name for push notifications. Only for API level 26+.
 * @property channelDescription Channel description for push notifications. Only for API level 26+.
 * @property channelId Channel ID for push notifications. Only for API level 26+.
 * @property pushIconResId Icon to be showed in push notifications. A drawable resource id expected.
 */
data class PushNotificationsConfiguration @JvmOverloads constructor(
    val pushEnabled: Boolean = true,
    var accentColor: Int? = null,
    var channelName: String = DEFAULT_NOTIFICATION_CHANNEL_NAME,
    var channelDescription: String = DEFAULT_NOTIFICATION_CHANNEL_DESCRIPTION,
    var channelId: String = DEFAULT_NOTIFICATION_CHANNEL_ID,
    @DrawableRes
    var pushIconResId: Int? = null,
)

private const val DEFAULT_NOTIFICATION_CHANNEL_ID = "meiro_notifications"
private const val DEFAULT_NOTIFICATION_CHANNEL_NAME = "Meiro"
private const val DEFAULT_NOTIFICATION_CHANNEL_DESCRIPTION = "Notifications"
