package io.meiro.sdk

import android.annotation.SuppressLint
import android.content.Context
import io.meiro.sdk.MeiroSdk.init
import io.meiro.sdk.audience.MeiroAudience

/**
 * Singleton object for interacting with Meiro SDK. Before using the SDK, you must call [init] method. This should
 * ideally happen in [android.app.Application.onCreate] method.
 */
object MeiroSdk : MeiroEvents {

    @SuppressLint("StaticFieldLeak")
    internal var impl: MeiroEventsImpl? = null

    override val userId: String
        get() = requireImpl().userId

    override val sessionId: String
        get() = requireImpl().sessionId

    override fun init(context: Context, configuration: Configuration, logger: MeiroLogger) {
        if (impl != null) {
            throw IllegalStateException("MeiroSdk.init must be called only once")
        }
        impl = MeiroEventsImpl().apply {
            init(context, configuration)
        }
    }

    override fun setEnabled(enabled: Boolean) {
        requireImpl().setEnabled(enabled)
    }

    override fun trackCustomEvent(properties: Map<String, Any>) {
        requireImpl().trackCustomEvent(properties)
    }

    override fun resetIdentity() {
        requireImpl().resetIdentity()
    }

    override fun trackLinkClick(url: String) {
        requireImpl().trackLinkClick(url)
    }

    override fun trackScreenView(name: String, properties: Map<String, Any>) {
        requireImpl().trackScreenView(name, properties)
    }

    override fun setFcmToken(token: String) {
        requireImpl().setFcmToken(token)
    }

    override fun getAudience(): MeiroAudience {
        return requireImpl().getAudience()
    }

    private fun requireImpl(): MeiroEventsImpl {
        return requireNotNull(impl) { "MeiroSdk.init must be called before using the SDK" }
    }

    internal suspend fun performSync() {
        impl?.performSync()
    }
}
