package io.meiro.sdk.offline

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query

@Dao
internal interface EventDao {

    @Insert
    suspend fun insert(event: DbEvent)

    @Query("DELETE FROM DbEvent WHERE timestamp < :timestamp")
    suspend fun deleteOlderThan(timestamp: Long)

    @Query("DELETE FROM DbEvent where id = :id")
    suspend fun deleteById(id: Int)

    @Query("SELECT * FROM DbEvent")
    suspend fun getAll(): List<DbEvent>
}
